/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PresignedUrlDownloadRequest
extends AmazonWebServiceRequest
implements Serializable {
    private URL presignedUrl;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private long[] range;

    public PresignedUrlDownloadRequest(URL presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    public URL getPresignedUrl() {
        return this.presignedUrl;
    }

    public void setPresignedUrl(URL presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    public PresignedUrlDownloadRequest withPresignedUrl(URL presignedUrl) {
        this.setPresignedUrl(presignedUrl);
        return this;
    }

    public long[] getRange() {
        return this.range == null ? null : (long[])this.range.clone();
    }

    public void setRange(long start, long end) {
        this.range = new long[]{start, end};
    }

    public PresignedUrlDownloadRequest withRange(long start, long end) {
        this.setRange(start, end);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> etagList) {
        this.matchingETagConstraints = etagList;
    }

    public PresignedUrlDownloadRequest withMatchingETagConstraint(String etag) {
        if (this.matchingETagConstraints == null) {
            this.matchingETagConstraints = new ArrayList<String>();
        }
        this.matchingETagConstraints.add(etag);
        return this;
    }

    public PresignedUrlDownloadRequest clone() {
        PresignedUrlDownloadRequest target = new PresignedUrlDownloadRequest(this.getPresignedUrl());
        this.copyBaseTo(target);
        if (this.getRange() != null) {
            target.setRange(this.getRange()[0], this.getRange()[1]);
        }
        if (this.getMatchingETagConstraints() != null) {
            target.setMatchingETagConstraints(new ArrayList<String>(this.getMatchingETagConstraints()));
        } else {
            target.setMatchingETagConstraints(null);
        }
        return target;
    }
}

