/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconSchemaVersionTableManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconSchemaVersionTableManager.class);
    public static final String RECON_SCHEMA_VERSION_TABLE_NAME = "RECON_SCHEMA_VERSION";
    private DSLContext dslContext;
    private final DataSource dataSource;

    @Inject
    public ReconSchemaVersionTableManager(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        this.dslContext = DSL.using((Connection)dataSource.getConnection());
    }

    public int getCurrentSchemaVersion() throws SQLException {
        try {
            return this.dslContext.select((SelectField)DSL.field((Name)DSL.name((String)"version_number"))).from((TableLike)DSL.table((String)RECON_SCHEMA_VERSION_TABLE_NAME)).fetchOptional().map(record -> (Integer)record.get(DSL.field((Name)DSL.name((String)"version_number"), Integer.class))).orElse(-1);
        }
        catch (Exception e) {
            LOG.error("Failed to fetch the current schema version.", (Throwable)e);
            throw new SQLException("Unable to read schema version from the table.", e);
        }
    }

    public void updateSchemaVersion(int newVersion, Connection conn) {
        this.dslContext = DSL.using((Connection)conn);
        boolean recordExists = this.dslContext.fetchExists((Select)this.dslContext.selectOne().from((TableLike)DSL.table((String)RECON_SCHEMA_VERSION_TABLE_NAME)));
        if (recordExists) {
            this.dslContext.update(DSL.table((String)RECON_SCHEMA_VERSION_TABLE_NAME)).set(DSL.field((Name)DSL.name((String)"version_number")), (Object)newVersion).set(DSL.field((Name)DSL.name((String)"applied_on")), (Object)DSL.currentTimestamp()).execute();
            LOG.info("Updated schema version to '{}'.", (Object)newVersion);
        } else {
            this.dslContext.insertInto(DSL.table((String)RECON_SCHEMA_VERSION_TABLE_NAME)).columns(DSL.field((Name)DSL.name((String)"version_number")), DSL.field((Name)DSL.name((String)"applied_on"))).values((Object)newVersion, (Object)DSL.currentTimestamp()).execute();
            LOG.info("Inserted new schema version '{}'.", (Object)newVersion);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

