/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdater;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdaterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconScmTask {
    private static final Logger LOG = LoggerFactory.getLogger(ReconScmTask.class);
    private Thread taskThread;
    private volatile boolean running;
    private final ReconTaskStatusUpdater taskStatusUpdater;

    protected ReconScmTask(ReconTaskStatusUpdaterManager taskStatusUpdaterManager) {
        this.taskStatusUpdater = taskStatusUpdaterManager.getTaskStatusUpdater(this.getTaskName());
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            LOG.info("Starting {} Thread.", (Object)this.getTaskName());
            this.running = true;
            this.taskThread = new Thread(this::run, "Recon-" + this.getTaskName());
            this.taskThread.setName(this.getTaskName());
            this.taskThread.setDaemon(true);
            this.taskThread.start();
        } else {
            LOG.info("{} Thread is already running.", (Object)this.getTaskName());
        }
    }

    public synchronized void stop() {
        if (this.running) {
            LOG.info("Stopping {} Thread.", (Object)this.getTaskName());
            this.running = false;
            this.notifyAll();
        } else {
            LOG.info("{} Thread is not running.", (Object)this.getTaskName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        if (!this.running) {
            ReconScmTask reconScmTask = this;
            synchronized (reconScmTask) {
                return this.taskThread != null && this.taskThread.isAlive();
            }
        }
        return true;
    }

    protected boolean canRun() {
        return this.running;
    }

    public String getTaskName() {
        return this.getClass().getSimpleName();
    }

    public ReconTaskStatusUpdater getTaskStatusUpdater() {
        return this.taskStatusUpdater;
    }

    protected abstract void run();

    protected void initializeAndRunTask() throws Exception {
        this.taskStatusUpdater.recordRunStart();
        this.runTask();
        this.taskStatusUpdater.recordRunCompletion();
    }

    protected abstract void runTask() throws Exception;
}

