/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.snapshot;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;

public class SnapshotDiffResponse {
    private final SnapshotDiffReportOzone snapshotDiffReport;
    private final JobStatus jobStatus;
    private final long waitTimeInMs;
    private final String reason;
    private SubStatus subStatus;
    private double progressPercent = 0.0;

    public SnapshotDiffResponse(SnapshotDiffReportOzone snapshotDiffReport, JobStatus jobStatus, long waitTimeInMs) {
        this.snapshotDiffReport = snapshotDiffReport;
        this.jobStatus = jobStatus;
        this.waitTimeInMs = waitTimeInMs;
        this.reason = "";
    }

    public SnapshotDiffResponse(SnapshotDiffReportOzone snapshotDiffReport, JobStatus jobStatus, long waitTimeInMs, String reason) {
        this.snapshotDiffReport = snapshotDiffReport;
        this.jobStatus = jobStatus;
        this.waitTimeInMs = waitTimeInMs;
        this.reason = reason;
    }

    public SnapshotDiffReportOzone getSnapshotDiffReport() {
        return this.snapshotDiffReport;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public long getWaitTimeInMs() {
        return this.waitTimeInMs;
    }

    public String getReason() {
        return this.reason;
    }

    public void setSubStatus(SubStatus subStatus) {
        this.subStatus = subStatus;
    }

    public void setProgressPercent(double progressPercent) {
        this.progressPercent = progressPercent;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        switch (this.jobStatus.ordinal()) {
            case 2: {
                str.append(this.snapshotDiffReport.toString());
                break;
            }
            case 4: {
                str.append("Snapshot diff job is FAILED due to '");
                if (StringUtils.isNotEmpty((CharSequence)this.reason)) {
                    str.append(this.reason);
                } else {
                    str.append("Unknown reason.");
                }
                str.append("'. Please retry after ").append(this.waitTimeInMs).append(" ms.\n");
                break;
            }
            case 5: {
                str.append("Snapshot diff job has been CANCELLED.");
                break;
            }
            default: {
                str.append("Snapshot diff job is ").append((Object)this.jobStatus).append(". Please retry after ").append(this.waitTimeInMs).append(" ms.\n");
                if (this.subStatus == null) break;
                str.append("SubStatus : ").append((Object)this.subStatus);
                if (!this.subStatus.equals((Object)SubStatus.OBJECT_ID_MAP_GEN_OBS) && !this.subStatus.equals((Object)SubStatus.OBJECT_ID_MAP_GEN_FSO)) break;
                str.append("Keys Processed Estimated Percentage : ").append(this.progressPercent);
            }
        }
        return str.toString();
    }

    public static enum JobStatus {
        QUEUED,
        IN_PROGRESS,
        DONE,
        REJECTED,
        FAILED,
        CANCELLED;


        public OzoneManagerProtocolProtos.SnapshotDiffResponse.JobStatusProto toProtobuf() {
            return OzoneManagerProtocolProtos.SnapshotDiffResponse.JobStatusProto.valueOf((String)this.name());
        }

        public static JobStatus fromProtobuf(OzoneManagerProtocolProtos.SnapshotDiffResponse.JobStatusProto jobStatusProto) {
            return JobStatus.valueOf(jobStatusProto.name());
        }
    }

    public static enum SubStatus {
        SST_FILE_DELTA_DAG_WALK,
        SST_FILE_DELTA_FULL_DIFF,
        OBJECT_ID_MAP_GEN_OBS,
        OBJECT_ID_MAP_GEN_FSO,
        DIFF_REPORT_GEN;


        public static SubStatus fromProtoBuf(OzoneManagerProtocolProtos.SnapshotDiffResponse.SubStatus subStatusProto) {
            return SubStatus.valueOf(subStatusProto.name());
        }

        public OzoneManagerProtocolProtos.SnapshotDiffResponse.SubStatus toProtoBuf() {
            return OzoneManagerProtocolProtos.SnapshotDiffResponse.SubStatus.valueOf((String)this.name());
        }
    }
}

