/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import com.google.protobuf.Proto2Utils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.util.Preconditions;

public final class PayloadUtils {
    private static final int MAX_SIZE = 2147482624;
    private static final byte[] SEED = RandomUtils.secure().randomBytes(1024);

    private PayloadUtils() {
    }

    public static byte[] generatePayload(int payloadSizeBytes) {
        int curIdx;
        int copySize;
        byte[] result = new byte[Math.min(payloadSizeBytes, 2147482624)];
        for (curIdx = 0; curIdx < result.length; curIdx += copySize) {
            int remaining = result.length - curIdx;
            copySize = Math.min(SEED.length, remaining);
            System.arraycopy(SEED, 0, result, curIdx, copySize);
        }
        Preconditions.assertTrue((curIdx == result.length ? 1 : 0) != 0);
        return result;
    }

    public static com.google.protobuf.ByteString generatePayloadProto2(int payloadSizeBytes) {
        return Proto2Utils.unsafeByteString((byte[])PayloadUtils.generatePayload(payloadSizeBytes));
    }

    public static ByteString generatePayloadProto3(int payloadSizeBytes) {
        return UnsafeByteOperations.unsafeWrap((byte[])PayloadUtils.generatePayload(payloadSizeBytes));
    }
}

