/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OmMetadataReaderMetrics;
import org.apache.hadoop.ozone.om.OzoneAclUtils;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.ListKeysLightResult;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.protocolPB.grpc.GrpcClientConstants;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

public class OmMetadataReader
implements IOmMetadataReader,
Auditor {
    private final KeyManager keyManager;
    private final PrefixManager prefixManager;
    private final VolumeManager volumeManager;
    private final BucketManager bucketManager;
    private final OzoneManager ozoneManager;
    private final boolean isAclEnabled;
    private final IAccessAuthorizer accessAuthorizer;
    private final OmMetadataReaderMetrics metrics;
    private final Logger log;
    private final AuditLogger audit;
    private final OMPerformanceMetrics perfMetrics;

    public OmMetadataReader(KeyManager keyManager, PrefixManager prefixManager, OzoneManager ozoneManager, Logger log, AuditLogger audit, OmMetadataReaderMetrics omMetadataReaderMetrics, IAccessAuthorizer accessAuthorizer) {
        this.keyManager = keyManager;
        this.bucketManager = ozoneManager.getBucketManager();
        this.volumeManager = ozoneManager.getVolumeManager();
        this.prefixManager = prefixManager;
        this.ozoneManager = ozoneManager;
        this.isAclEnabled = ozoneManager.getAclsEnabled();
        this.log = log;
        this.audit = audit;
        this.metrics = omMetadataReaderMetrics;
        this.perfMetrics = ozoneManager.getPerfMetrics();
        this.accessAuthorizer = accessAuthorizer != null ? accessAuthorizer : OzoneAccessAuthorizer.get();
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        long start = Time.monotonicNowNanos();
        ResolvedBucket bucket = (ResolvedBucket)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getLookupResolveBucketLatencyNs(), () -> this.ozoneManager.resolveBucketLink(args));
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        OmKeyArgs resolvedArgs = bucket.update(args);
        try {
            if (this.isAclEnabled) {
                MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getLookupAclCheckLatencyNs(), () -> this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket, args.getKeyName()));
            }
            this.metrics.incNumKeyLookups();
            OmKeyInfo omKeyInfo = this.keyManager.lookupKey(resolvedArgs, bucket, OmMetadataReader.getClientAddress());
            return omKeyInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumKeyLookupFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.READ_KEY, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.READ_KEY, auditMap));
            }
            this.perfMetrics.addLookupLatency(Time.monotonicNowNanos() - start);
        }
    }

    public KeyInfoWithVolumeContext getKeyInfo(OmKeyArgs args, boolean assumeS3Context) throws IOException {
        OmKeyArgs resolvedVolumeArgs;
        long start = Time.monotonicNowNanos();
        Optional<Object> s3VolumeContext = Optional.empty();
        if (assumeS3Context) {
            S3VolumeContext context2 = this.ozoneManager.getS3VolumeContext(true);
            s3VolumeContext = Optional.of(context2);
            resolvedVolumeArgs = args.toBuilder().setVolumeName(context2.getOmVolumeArgs().getVolume()).build();
        } else {
            resolvedVolumeArgs = args;
        }
        ResolvedBucket bucket = (ResolvedBucket)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getGetKeyInfoResolveBucketLatencyNs(), () -> this.ozoneManager.resolveBucketLink(resolvedVolumeArgs));
        boolean auditSuccess = true;
        OmKeyArgs resolvedArgs = bucket.update(resolvedVolumeArgs);
        try {
            if (this.isAclEnabled) {
                MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getGetKeyInfoAclCheckLatencyNs(), () -> this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket, args.getKeyName()));
            }
            this.metrics.incNumGetKeyInfo();
            OmKeyInfo keyInfo = this.keyManager.getKeyInfo(resolvedArgs, bucket, OmMetadataReader.getClientAddress());
            KeyInfoWithVolumeContext.Builder builder = KeyInfoWithVolumeContext.newBuilder().setKeyInfo(keyInfo);
            s3VolumeContext.ifPresent(context -> {
                builder.setVolumeArgs(context.getOmVolumeArgs());
                builder.setUserPrincipal(context.getUserPrincipal());
            });
            KeyInfoWithVolumeContext keyInfoWithVolumeContext = builder.build();
            return keyInfoWithVolumeContext;
        }
        catch (Exception ex) {
            this.metrics.incNumGetKeyInfoFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.READ_KEY, bucket.audit(resolvedVolumeArgs.toAuditMap()), ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.READ_KEY, bucket.audit(resolvedVolumeArgs.toAuditMap())));
            }
            this.perfMetrics.addGetKeyInfoLatencyNs(Time.monotonicNowNanos() - start);
        }
    }

    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        long maxListingPageSize = this.ozoneManager.getConfiguration().getInt("ozone.fs.listing.page.size.max", 1024);
        maxListingPageSize = OzoneConfigUtil.limitValue(numEntries, "ozone.fs.listing.page.size", "ozone.fs.listing.page.size.max", maxListingPageSize);
        ResolvedBucket bucket = this.ozoneManager.resolveBucketLink(args);
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            if (this.isAclEnabled) {
                this.checkAcls(this.getResourceType(args), OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket, args.getKeyName());
            }
            this.metrics.incNumListStatus();
            List<OzoneFileStatus> list = this.keyManager.listStatus(args, recursive, startKey, maxListingPageSize, OmMetadataReader.getClientAddress(), allowPartialPrefixes);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumListStatusFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_STATUS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_STATUS, auditMap));
            }
        }
    }

    public List<OzoneFileStatusLight> listStatusLight(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        List<OzoneFileStatus> ozoneFileStatuses = this.listStatus(args, recursive, startKey, numEntries, allowPartialPrefixes);
        return ozoneFileStatuses.stream().map(OzoneFileStatusLight::fromOzoneFileStatus).collect(Collectors.toList());
    }

    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.ozoneManager.resolveBucketLink(args);
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            this.metrics.incNumGetFileStatus();
            OzoneFileStatus ozoneFileStatus = this.keyManager.getFileStatus(args, OmMetadataReader.getClientAddress());
            return ozoneFileStatus;
        }
        catch (IOException ex) {
            this.metrics.incNumGetFileStatusFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.GET_FILE_STATUS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.GET_FILE_STATUS, auditMap));
            }
        }
    }

    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        ResolvedBucket bucket = this.ozoneManager.resolveBucketLink(args);
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        args = bucket.update(args);
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket, args.getKeyName());
            }
            this.metrics.incNumLookupFile();
            OmKeyInfo omKeyInfo = this.keyManager.lookupFile(args, OmMetadataReader.getClientAddress());
            return omKeyInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumLookupFileFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.LOOKUP_FILE, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LOOKUP_FILE, auditMap));
            }
        }
    }

    public ListKeysResult listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        long startNanos = Time.monotonicNowNanos();
        ResolvedBucket bucket = (ResolvedBucket)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getListKeysResolveBucketLatencyNs(), () -> this.ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName)));
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit();
        auditMap.put("startKey", startKey);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("keyPrefix", keyPrefix);
        try {
            if (this.isAclEnabled) {
                MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getListKeysAclCheckLatencyNs(), () -> this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, bucket.realVolume(), bucket.realBucket(), keyPrefix));
            }
            this.metrics.incNumKeyLists();
            ListKeysResult listKeysResult = this.keyManager.listKeys(bucket.realVolume(), bucket.realBucket(), startKey, keyPrefix, maxKeys);
            return listKeysResult;
        }
        catch (IOException ex) {
            this.metrics.incNumKeyListFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_KEYS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_KEYS, auditMap));
            }
            this.perfMetrics.addListKeysLatencyNs(Time.monotonicNowNanos() - startNanos);
        }
    }

    public ListKeysLightResult listKeysLight(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        ListKeysResult listKeysResult = this.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
        List keys = listKeysResult.getKeys();
        List basicKeysList = keys.stream().map(BasicOmKeyInfo::fromOmKeyInfo).collect(Collectors.toList());
        return new ListKeysLightResult(basicKeysList, listKeysResult.isTruncated());
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        String volumeName = obj.getVolumeName();
        String bucketName = obj.getBucketName();
        String keyName = obj.getKeyName();
        if (obj.getResourceType() == OzoneObj.ResourceType.KEY || obj.getResourceType() == OzoneObj.ResourceType.PREFIX) {
            ResolvedBucket resolvedBucket = this.ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
            volumeName = resolvedBucket.realVolume();
            bucketName = resolvedBucket.realBucket();
        }
        boolean auditSuccess = true;
        try {
            if (this.isAclEnabled) {
                this.checkAcls(obj.getResourceType(), obj.getStoreType(), IAccessAuthorizer.ACLType.READ_ACL, volumeName, bucketName, keyName);
            }
            this.metrics.incNumGetAcl();
            switch (obj.getResourceType()) {
                case VOLUME: {
                    List<OzoneAcl> list = this.volumeManager.getAcl(obj);
                    return list;
                }
                case BUCKET: {
                    List<OzoneAcl> list = this.bucketManager.getAcl(obj);
                    return list;
                }
                case KEY: {
                    List<OzoneAcl> list = this.keyManager.getAcl(obj);
                    return list;
                }
                case PREFIX: {
                    List<OzoneAcl> list = this.prefixManager.getAcl(obj);
                    return list;
                }
            }
            try {
                throw new OMException("Unexpected resource type: " + obj.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
            }
            catch (Exception ex) {
                auditSuccess = false;
                this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.GET_ACL, obj.toAuditMap(), ex));
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.GET_ACL, obj.toAuditMap()));
            }
        }
    }

    public Map<String, String> getObjectTagging(OmKeyArgs args) throws IOException {
        long start = Time.monotonicNowNanos();
        ResolvedBucket bucket = (ResolvedBucket)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getLookupResolveBucketLatencyNs(), () -> this.ozoneManager.resolveBucketLink(args));
        boolean auditSuccess = true;
        Map<String, String> auditMap = bucket.audit(args.toAuditMap());
        OmKeyArgs resolvedArgs = bucket.update(args);
        try {
            if (this.isAclEnabled) {
                MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getGetObjectTaggingAclCheckLatencyNs(), () -> this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, bucket, args.getKeyName()));
            }
            this.metrics.incNumGetObjectTagging();
            Map<String, String> map = this.keyManager.getObjectTagging(resolvedArgs, bucket);
            return map;
        }
        catch (Exception ex) {
            this.metrics.incNumGetObjectTaggingFails();
            auditSuccess = false;
            this.audit.logReadFailure(this.buildAuditMessageForFailure(OMAction.GET_OBJECT_TAGGING, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                this.audit.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.GET_OBJECT_TAGGING, auditMap));
            }
            this.perfMetrics.addGetObjectTaggingLatencyNs(Time.monotonicNowNanos() - start);
        }
    }

    void checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, String vol, String bucket, String key) throws IOException {
        UserGroupInformation user;
        if (OzoneManager.getS3Auth() != null) {
            String principal = OzoneAclUtils.accessIdToUserPrincipal(OzoneManager.getS3Auth().getAccessId());
            user = UserGroupInformation.createRemoteUser((String)principal);
        } else {
            user = ProtobufRpcEngine.Server.getRemoteUser();
        }
        InetAddress remoteIp = ProtobufRpcEngine.Server.getRemoteIp();
        String volumeOwner = this.ozoneManager.getVolumeOwner(vol, acl, resType);
        String bucketOwner = this.ozoneManager.getBucketOwner(vol, bucket, acl, resType);
        OzoneAclUtils.checkAllAcls(this, resType, store, acl, vol, bucket, key, volumeOwner, bucketOwner, user != null ? user : HddsServerUtil.getRemoteUser(), remoteIp != null ? remoteIp : this.ozoneManager.getOmRpcServerAddr().getAddress(), remoteIp != null ? remoteIp.getHostName() : this.ozoneManager.getOmRpcServerAddr().getHostName());
    }

    void checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, ResolvedBucket resolvedBucket, String key) throws IOException {
        UserGroupInformation user;
        if (OzoneManager.getS3Auth() != null) {
            String principal = OzoneAclUtils.accessIdToUserPrincipal(OzoneManager.getS3Auth().getAccessId());
            user = UserGroupInformation.createRemoteUser((String)principal);
        } else {
            user = ProtobufRpcEngine.Server.getRemoteUser();
        }
        String vol = resolvedBucket.realVolume();
        String bucket = resolvedBucket.realBucket();
        InetAddress remoteIp = ProtobufRpcEngine.Server.getRemoteIp();
        String volumeOwner = this.ozoneManager.getVolumeOwner(vol, acl, resType);
        String bucketOwner = resolvedBucket.bucketOwner();
        OzoneAclUtils.checkAllAcls(this, resType, store, acl, vol, bucket, key, volumeOwner, bucketOwner, user != null ? user : HddsServerUtil.getRemoteUser(), remoteIp != null ? remoteIp : this.ozoneManager.getOmRpcServerAddr().getAddress(), remoteIp != null ? remoteIp.getHostName() : this.ozoneManager.getOmRpcServerAddr().getHostName());
    }

    public boolean checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key, UserGroupInformation ugi, InetAddress remoteAddress, String hostName, boolean throwIfPermissionDenied, String owner) throws OMException {
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setResType(resType).setStoreType(storeType).setVolumeName(vol).setBucketName(bucket).setKeyName(key).build();
        RequestContext context = RequestContext.newBuilder().setClientUgi(ugi).setIp(remoteAddress).setHost(hostName).setAclType(IAccessAuthorizer.ACLIdentityType.USER).setAclRights(aclType).setOwnerName(owner).build();
        return this.checkAcls((OzoneObj)obj, context, throwIfPermissionDenied);
    }

    public boolean checkAcls(OzoneObj obj, RequestContext context, boolean throwIfPermissionDenied) throws OMException {
        if (!((Boolean)MetricUtil.captureLatencyNs(this.perfMetrics::setCheckAccessLatencyNs, () -> this.accessAuthorizer.checkAccess((IOzoneObj)obj, context))).booleanValue()) {
            if (throwIfPermissionDenied) {
                String volumeName = obj.getVolumeName() != null ? "Volume:" + obj.getVolumeName() + " " : "";
                String bucketName = obj.getBucketName() != null ? "Bucket:" + obj.getBucketName() + " " : "";
                String keyName = obj.getKeyName() != null ? "Key:" + obj.getKeyName() : "";
                this.log.warn("User {} doesn't have {} permission to access {} {}{}{}", new Object[]{context.getClientUgi().getShortUserName(), context.getAclRights(), obj.getResourceType(), volumeName, bucketName, keyName});
                throw new OMException("User " + context.getClientUgi().getShortUserName() + " doesn't have " + context.getAclRights() + " permission to access " + obj.getResourceType() + " " + volumeName + bucketName + keyName, OMException.ResultCodes.PERMISSION_DENIED);
            }
            return false;
        }
        return true;
    }

    static String getClientAddress() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            String clientIpAddress = (String)GrpcClientConstants.CLIENT_IP_ADDRESS_CTX_KEY.get();
            clientMachine = clientIpAddress != null ? clientIpAddress : "";
        }
        return clientMachine;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(OmMetadataReader.getClientAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(OmMetadataReader.getClientAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    public boolean isNativeAuthorizerEnabled() {
        return this.accessAuthorizer.isNative();
    }

    private OzoneObj.ResourceType getResourceType(OmKeyArgs args) {
        if (args.getKeyName() == null || args.getKeyName().isEmpty()) {
            return OzoneObj.ResourceType.BUCKET;
        }
        return OzoneObj.ResourceType.KEY;
    }
}

