/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInfoProvider.class);
    private final OzoneManagerProtocol om;
    private final CertificateClient certClient;
    private String caCertPEM;
    private List<String> caCertPEMList;

    ServiceInfoProvider(SecurityConfig config, OzoneManagerProtocol om, CertificateClient certClient) {
        this(config, om, certClient, false);
    }

    ServiceInfoProvider(SecurityConfig config, OzoneManagerProtocol om, CertificateClient certClient, boolean skipInitializationForTesting) {
        this.om = om;
        if (config.isSecurityEnabled() && !skipInitializationForTesting) {
            this.certClient = certClient;
            Set<X509Certificate> certs = this.getCACertificates();
            this.caCertPEM = this.toPEMEncodedString(this.newestOf(certs));
            this.caCertPEMList = this.toPEMEncodedStrings(certs);
            this.certClient.registerRootCARotationListener(this.onRootCAChange());
        } else {
            this.certClient = null;
            this.caCertPEM = null;
            this.caCertPEMList = Collections.emptyList();
        }
    }

    private Function<List<X509Certificate>, CompletableFuture<Void>> onRootCAChange() {
        return certs -> {
            CompletableFuture returnedFuture = new CompletableFuture();
            try {
                ServiceInfoProvider serviceInfoProvider = this;
                synchronized (serviceInfoProvider) {
                    this.caCertPEM = this.toPEMEncodedString(this.newestOf((Collection<X509Certificate>)certs));
                    this.caCertPEMList = this.toPEMEncodedStrings((Collection<X509Certificate>)certs);
                }
                returnedFuture.complete(null);
            }
            catch (Exception e) {
                LOG.error("Unable to refresh cached PEM formatted CA certificates.", (Throwable)e);
                returnedFuture.completeExceptionally(e);
            }
            return returnedFuture;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfoEx provide() throws IOException {
        ArrayList<String> returnedCaCertPEMList;
        String returnedCaCertPEM;
        ServiceInfoProvider serviceInfoProvider = this;
        synchronized (serviceInfoProvider) {
            returnedCaCertPEM = this.caCertPEM;
            returnedCaCertPEMList = new ArrayList<String>(this.caCertPEMList);
        }
        return new ServiceInfoEx(this.om.getServiceList(), returnedCaCertPEM, returnedCaCertPEMList);
    }

    private Set<X509Certificate> getCACertificates() {
        Set rootCerts = this.certClient.getAllRootCaCerts();
        return !rootCerts.isEmpty() ? rootCerts : this.certClient.getAllCaCerts();
    }

    private X509Certificate newestOf(Collection<X509Certificate> certs) {
        return certs.stream().max(Comparator.comparing(X509Certificate::getNotAfter)).orElse(null);
    }

    private String toPEMEncodedString(X509Certificate cert) {
        try {
            return cert == null ? null : CertificateCodec.getPEMEncodedString((X509Certificate)cert);
        }
        catch (SCMSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> toPEMEncodedStrings(Collection<X509Certificate> certs) {
        return certs.stream().map(this::toPEMEncodedString).collect(Collectors.toList());
    }
}

