/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMSetRangerServiceVersionResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMSetRangerServiceVersionRequest
extends OMClientRequest {
    public OMSetRangerServiceVersionRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.SetRangerServiceVersionRequest request = this.getOmRequest().getSetRangerServiceVersionRequest();
        long proposedVersion = request.getRangerServiceVersion();
        String proposedVersionStr = String.valueOf(proposedVersion);
        omMetadataManager.getMetaTable().addCacheEntry(new CacheKey((Object)"#RANGEROZONESERVICEVERSION"), CacheValue.get((long)context.getIndex(), (Object)proposedVersionStr));
        omResponse.setSetRangerServiceVersionResponse(OzoneManagerProtocolProtos.SetRangerServiceVersionResponse.newBuilder().build());
        OMSetRangerServiceVersionResponse omClientResponse = new OMSetRangerServiceVersionResponse(omResponse.build(), "#RANGEROZONESERVICEVERSION", proposedVersionStr);
        return omClientResponse;
    }
}

