/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCompleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openFileTable", "fileTable", "deletedTable", "multipartInfoTable", "directoryTable"})
public class S3MultipartUploadCompleteResponseWithFSO
extends S3MultipartUploadCompleteResponse {
    private long volumeId;
    private long bucketId;
    private List<OmDirectoryInfo> missingParentInfos;
    private OmMultipartKeyInfo multipartKeyInfo;

    public S3MultipartUploadCompleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String multipartKey, @Nonnull String multipartOpenKey, @Nonnull OmKeyInfo omKeyInfo, @Nonnull List<OmKeyInfo> allKeyInfoToRemove, @Nonnull BucketLayout bucketLayout, OmBucketInfo omBucketInfo, @Nonnull long volumeId, @Nonnull long bucketId, List<OmDirectoryInfo> missingParentInfos, OmMultipartKeyInfo multipartKeyInfo) {
        super(omResponse, multipartKey, multipartOpenKey, omKeyInfo, allKeyInfoToRemove, bucketLayout, omBucketInfo, bucketId);
        this.volumeId = volumeId;
        this.bucketId = bucketId;
        this.missingParentInfos = missingParentInfos;
        this.multipartKeyInfo = multipartKeyInfo;
    }

    public S3MultipartUploadCompleteResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.missingParentInfos != null) {
            for (OmDirectoryInfo parentDirInfo : this.missingParentInfos) {
                String parentKey = omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, parentDirInfo.getParentObjectID(), parentDirInfo.getName());
                omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)parentKey, (Object)parentDirInfo);
            }
            OmBucketInfo omBucketInfo = this.getOmBucketInfo();
            if (omBucketInfo != null) {
                String bucketKey = omMetadataManager.getBucketKey(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName());
                omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)bucketKey, (Object)omBucketInfo);
            }
            if (OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, this.getMultiPartKey(), this.getOmKeyInfo().getKeyName()) != null) {
                OMFileRequest.addToOpenFileTableForMultipart(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.multipartKeyInfo.getUploadID(), this.volumeId, this.bucketId);
            }
        }
        super.addToDBBatch(omMetadataManager, batchOperation);
    }

    @Override
    protected String addToKeyTable(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneKey = omMetadataManager.getOzoneKey(this.getOmKeyInfo().getVolumeName(), this.getOmKeyInfo().getBucketName(), this.getOmKeyInfo().getKeyName());
        OMFileRequest.addToFileTable(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.volumeId, this.bucketId);
        return ozoneKey;
    }
}

