---
title: "Committer"
weight: 4
type: docs
aliases:
- /project/committer.html
---
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Committer

## Become a Committer

#### How to become a committer

There is no strict protocol for becoming a committer. Candidates for new committers are typically people that are
active contributors and community members. Candidates are suggested by current committers or PMC members, and
voted upon by the PMC.

If you would like to become a committer, you should engage with the community and start contributing to Apache Paimon in
any of the above ways. You might also want to talk to other committers and ask for their advice and guidance.

- Community contributions include helping to answer user questions on the mailing list, verifying release candidates,
  giving talks, organizing community events, and other forms of evangelism and community building. The "Apache Way" has
  a strong focus on the project community, and committers can be recognized for outstanding community contributions even
  without any code contributions.

- Code/technology contributions include contributed pull requests (patches), design discussions, reviews, testing,
  and other help in identifying and fixing bugs. Especially constructive and high quality design discussions, as well
  as helping other contributors, are strong indicators.

#### Identify promising candidates

While the prior points give ways to identify promising candidates, the following are "must haves" for any committer candidate:

- Being community minded: The candidate understands the meritocratic principles of community management. They do not
  always optimize for as much as possible personal contribution, but will help and empower others where it makes sense.

- We trust that a committer candidate will use their write access to the repositories responsibly, and if in doubt,
  conservatively. It is important that committers are aware of what they know and what they don't know. In doubt,
  committers should ask for a second pair of eyes rather than commit to parts that they are not well familiar with.

- They have shown to be respectful towards other community members and constructive in discussions.

## Committer Rights

JetBrains provides a free license to Apache Committers, allowing them to access all JetBrains IDEs, such as
IntelliJ IDEA, PyCharm, and other desktop tools.

Please use your @apache.org email address to [All Products Packs for Apache committers](https://www.jetbrains.com/shop/eform/apache?product=ALL).
