/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConnectors {
    private MiniDFSCluster cluster;
    private final int numDatanodes = 3;
    private final int volumeCount = 2;
    private Configuration conf;

    @Before
    public void setup() throws IOException {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testNameNodeConnector() throws Exception {
        this.cluster.waitActive();
        ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)this.cluster.getFileSystem(0).getUri(), (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
        diskBalancerCluster.readClusterInfo();
        Assert.assertEquals((String)"Expected number of Datanodes not found.", (long)3L, (long)diskBalancerCluster.getNodes().size());
        Assert.assertEquals((String)"Expected number of volumes not found.", (long)2L, (long)((DiskBalancerDataNode)diskBalancerCluster.getNodes().get(0)).getVolumeCount());
    }

    @Test
    public void testJsonConnector() throws Exception {
        this.cluster.waitActive();
        ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)this.cluster.getFileSystem(0).getUri(), (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
        diskBalancerCluster.readClusterInfo();
        String diskBalancerJson = diskBalancerCluster.toJson();
        DiskBalancerCluster serializedCluster = DiskBalancerCluster.parseJson((String)diskBalancerJson);
        Assert.assertEquals((String)"Parsed cluster is not equal to persisted info.", (long)diskBalancerCluster.getNodes().size(), (long)serializedCluster.getNodes().size());
    }
}

