/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MiscTests.class, SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestKeyOnlyFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestKeyOnlyFilter.class);
    @Parameterized.Parameter
    public boolean lenAsVal;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseCommonTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    @Test
    public void testKeyOnly() throws Exception {
        byte[] r = Bytes.toBytes((String)"row1");
        byte[] f = Bytes.toBytes((String)"cf1");
        byte[] q = Bytes.toBytes((String)"qual1");
        byte[] v = Bytes.toBytes((String)"val1");
        byte[] tags = Bytes.toBytes((String)"tag1");
        KeyValue kv = new KeyValue(r, f, q, 0, q.length, 1234L, KeyValue.Type.Put, v, 0, v.length, tags);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        int dataLen = this.lenAsVal ? 4 : 0;
        int keyOffset = 8;
        int keyLen = KeyValueUtil.keyLength((Cell)kv);
        byte[] newBuffer = new byte[keyLen + keyOffset + dataLen];
        Bytes.putInt((byte[])newBuffer, (int)0, (int)keyLen);
        Bytes.putInt((byte[])newBuffer, (int)4, (int)dataLen);
        KeyValueUtil.appendKeyTo((Cell)kv, (byte[])newBuffer, (int)keyOffset);
        if (this.lenAsVal) {
            Bytes.putInt((byte[])newBuffer, (int)(newBuffer.length - dataLen), (int)kv.getValueLength());
        }
        KeyValue KeyOnlyKeyValue2 = new KeyValue(newBuffer);
        KeyOnlyFilter.KeyOnlyCell keyOnlyCell = new KeyOnlyFilter.KeyOnlyCell((Cell)kv, this.lenAsVal);
        KeyOnlyFilter.KeyOnlyByteBufferExtendedCell keyOnlyByteBufferedCell = new KeyOnlyFilter.KeyOnlyByteBufferExtendedCell((ByteBufferExtendedCell)bbCell, this.lenAsVal);
        Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyCell));
        Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyByteBufferedCell));
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyCell));
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyByteBufferedCell));
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyCell));
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyByteBufferedCell));
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyCell));
        Assert.assertTrue((KeyOnlyKeyValue2.getValueLength() == keyOnlyByteBufferedCell.getValueLength() ? 1 : 0) != 0);
        Assert.assertEquals((long)(8 + keyLen + (this.lenAsVal ? 4 : 0)), (long)KeyOnlyKeyValue2.getSerializedSize());
        Assert.assertEquals((long)(8 + keyLen + (this.lenAsVal ? 4 : 0)), (long)keyOnlyCell.getSerializedSize());
        if (keyOnlyByteBufferedCell.getValueLength() > 0) {
            Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)KeyOnlyKeyValue2, (Cell)keyOnlyByteBufferedCell));
        }
        Assert.assertTrue((KeyOnlyKeyValue2.getTimestamp() == keyOnlyCell.getTimestamp() ? 1 : 0) != 0);
        Assert.assertTrue((KeyOnlyKeyValue2.getTimestamp() == keyOnlyByteBufferedCell.getTimestamp() ? 1 : 0) != 0);
        Assert.assertTrue((KeyOnlyKeyValue2.getTypeByte() == keyOnlyCell.getTypeByte() ? 1 : 0) != 0);
        Assert.assertTrue((KeyOnlyKeyValue2.getTypeByte() == keyOnlyByteBufferedCell.getTypeByte() ? 1 : 0) != 0);
        Assert.assertTrue((KeyOnlyKeyValue2.getTagsLength() == keyOnlyCell.getTagsLength() ? 1 : 0) != 0);
        Assert.assertTrue((KeyOnlyKeyValue2.getTagsLength() == keyOnlyByteBufferedCell.getTagsLength() ? 1 : 0) != 0);
    }
}

