/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class CopyInstr
extends Instr
implements ResultInstr {
    private Operand arg;
    private Variable result;

    public CopyInstr(Variable result2, Operand s2) {
        super(Operation.COPY);
        assert (result2 != null) : "CopyInstr result is null";
        assert (s2 != null);
        this.arg = s2;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.arg};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    public Operand getSource() {
        return this.arg;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.arg = this.arg.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return this.arg;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new CopyInstr(ii.getRenamedVariable(this.result), this.arg.cloneForInlining(ii));
    }

    @Override
    public String toString() {
        return this.arg instanceof Variable ? super.toString() + "(" + this.arg + ")" : this.result + " = " + this.arg;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CopyInstr(this);
    }
}

