/*
 * Decompiled with CFR 0.152.
 */
package sdsu.html;

import sdsu.html.Formatter;
import sdsu.html.HTML;
import sdsu.util.Table;

public class HTMLTable
implements HTML {
    private String[][] tableElements;
    private String caption = null;
    private int borderWidth = 1;
    private String alignment = "left";
    private String width = null;
    private int labelRow = -1;
    private int labelColumn = -1;
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String emptyString = "&nbsp;";

    public HTMLTable(int n, int n2) {
        this.tableElements = new String[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.tableElements[n3][n4] = emptyString;
                ++n4;
            }
            ++n3;
        }
    }

    public HTMLTable(Table table) {
        int n = table.numberOfRows();
        int n2 = table.numberOfColumns();
        this.tableElements = new String[n][n2];
        try {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    Object object = table.elementAt(n3, n4);
                    if (object == null) {
                        object = emptyString;
                    }
                    this.tableElements[n3][n4] = object.toString();
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    private void addTableCells(StringBuffer stringBuffer) {
        String[][] stringArray = this.tableElements;
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("\n  <TR>");
            int n4 = 0;
            while (n4 < n2) {
                String string = this.getCellTag(n3, n4);
                stringBuffer.append("<" + string + ">");
                stringBuffer.append(stringArray[n3][n4]);
                stringBuffer.append("</" + string + ">");
                ++n4;
            }
            stringBuffer.append("</TR>");
            ++n3;
        }
    }

    private void addTableEnding(StringBuffer stringBuffer) {
        stringBuffer.append("\n</TABLE>");
        if (this.alignment.equals(CENTER)) {
            stringBuffer.append("\n</CENTER>");
        }
    }

    private void addTableHeader(StringBuffer stringBuffer) {
        if (this.alignment.equals(CENTER)) {
            stringBuffer.append("\n<CENTER>");
        }
        stringBuffer.append("\n<TABLE ");
        if (this.borderWidth > 0) {
            stringBuffer.append(" BORDER=\"");
            stringBuffer.append(this.borderWidth);
            stringBuffer.append("\"");
        }
        if (!this.alignment.equals(LEFT)) {
            stringBuffer.append(" ALIGN=\"");
            stringBuffer.append(this.alignment);
            stringBuffer.append("\"");
        }
        if (this.width != null) {
            stringBuffer.append(" WIDTH=\"");
            stringBuffer.append(this.width);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (this.caption != null) {
            stringBuffer.append("\n<CAPTION>" + this.caption + "</CAPTION>");
        }
    }

    public void alignCenter() {
        this.alignment = CENTER;
    }

    public void alignLeft() {
        this.alignment = LEFT;
    }

    public void alignRight() {
        this.alignment = RIGHT;
    }

    public String elementAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        return this.tableElements[n][n2];
    }

    private String getCellTag(int n, int n2) {
        if (n == this.labelRow || n2 == this.labelColumn) {
            return "TH";
        }
        return "TD";
    }

    public void makeColumnAHeader(int n) {
        this.labelColumn = n;
    }

    public void makeRowAHeader(int n) {
        this.labelRow = n;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public void setCaption(Formatter formatter) {
        this.caption = formatter.toString();
    }

    public void setElementAt(Object object, int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.setElementAt(new Formatter(object.toString()), n, n2);
    }

    public void setElementAt(HTML hTML, int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.tableElements[n][n2] = hTML.toString();
    }

    public void setWidth(int n) {
        this.width = String.valueOf(n);
    }

    public void setWidthPercent(int n) {
        this.width = "\"" + String.valueOf(n) + "%\"";
    }

    public String toString() {
        int n = this.tableElements.length * this.tableElements[0].length;
        StringBuffer stringBuffer = new StringBuffer(3 * n + 10);
        this.addTableHeader(stringBuffer);
        this.addTableCells(stringBuffer);
        this.addTableEnding(stringBuffer);
        return stringBuffer.toString();
    }
}

