/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.w3c.domts.DOMTest.load;


/**
 * The method hasAttributeNS returns true when an attribute with a given local
 * name and namespace URI is specified on this element or has a default value,
 * false otherwise.
 * Create a new element and attribute node that belong to the same namespace.
 * Add the attribute node to the element node.  Check if the newly created element
 * node has an attribute by invoking the hasAttributeNS method with appropriate
 * values for the namespaceURI and localName parameters.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElHasAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElHasAttrNS</a>
 */
public class elementhasattributens02 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staff", false);
        Element element = doc.createElementNS("http://www.w3.org/DOM", "address");
        Attr attribute = doc.createAttributeNS("http://www.w3.org/DOM", "domestic");
        Attr newAttribute = element.setAttributeNode(attribute);
        boolean state = element.hasAttributeNS("http://www.w3.org/DOM", "domestic");
        assertTrue(state, "elementhasattributens02");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementhasattributens02";
    }

}
