/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceStability.Evolving
public class ManagedLedgerImplUtils {
    public static CompletableFuture<Position> asyncGetLastValidPosition(ManagedLedgerImpl ledger, Predicate<Entry> predicate, PositionImpl startPosition) {
        CompletableFuture<Position> future = new CompletableFuture<Position>();
        ManagedLedgerImplUtils.internalAsyncReverseFindPositionOneByOne(ledger, predicate, startPosition, future);
        return future;
    }

    private static void internalAsyncReverseFindPositionOneByOne(final ManagedLedgerImpl ledger, final Predicate<Entry> predicate, PositionImpl position, final CompletableFuture<Position> future) {
        if (!ledger.isValidPosition(position)) {
            future.complete(position);
            return;
        }
        ledger.asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readEntryComplete(Entry entry, Object ctx) {
                Position position = entry.getPosition();
                try {
                    if (predicate.test(entry)) {
                        future.complete(position);
                        return;
                    }
                    PositionImpl previousPosition = ledger.getPreviousPosition((PositionImpl)position);
                    ManagedLedgerImplUtils.internalAsyncReverseFindPositionOneByOne(ledger, predicate, previousPosition, future);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
                finally {
                    entry.release();
                }
            }

            @Override
            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null);
    }
}

