/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class QueryInputMetadata {
    private final String catalogName;
    private final String schema;
    private final String table;
    private final List<String> columns;
    private final Optional<Object> connectorInfo;
    private final OptionalLong physicalInputBytes;
    private final OptionalLong physicalInputRows;

    @JsonCreator
    public QueryInputMetadata(String catalogName, String schema, String table, List<String> columns, Optional<Object> connectorInfo, OptionalLong physicalInputBytes, OptionalLong physicalInputRows) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.connectorInfo = Objects.requireNonNull(connectorInfo, "connectorInfo is null");
        this.physicalInputBytes = Objects.requireNonNull(physicalInputBytes, "physicalInputBytes is null");
        this.physicalInputRows = Objects.requireNonNull(physicalInputRows, "physicalInputRows is null");
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<Object> getConnectorInfo() {
        return this.connectorInfo;
    }

    @JsonProperty
    public OptionalLong getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @JsonProperty
    public OptionalLong getPhysicalInputRows() {
        return this.physicalInputRows;
    }
}

