/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.trino.operator.window.WindowAnnotationsParser;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.WindowFunction;
import java.util.Collection;
import java.util.List;

public final class FunctionExtractor {
    private FunctionExtractor() {
    }

    public static List<? extends SqlFunction> extractFunctions(Collection<Class<?>> classes) {
        return (List)classes.stream().map(FunctionExtractor::extractFunctions).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public static List<? extends SqlFunction> extractFunctions(Class<?> clazz) {
        if (WindowFunction.class.isAssignableFrom(clazz)) {
            Class<?> windowClazz = clazz;
            return WindowAnnotationsParser.parseFunctionDefinition(windowClazz);
        }
        if (clazz.isAnnotationPresent(AggregationFunction.class)) {
            return SqlAggregationFunction.createFunctionsByAnnotations(clazz);
        }
        if (clazz.isAnnotationPresent(ScalarFunction.class) || clazz.isAnnotationPresent(ScalarOperator.class)) {
            return ScalarFromAnnotationsParser.parseFunctionDefinition(clazz);
        }
        return ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz);
    }
}

