/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.mledger.impl.OpAddEntry;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.intercept.AppendIndexMetadataInterceptor;
import org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;
import org.apache.pulsar.common.intercept.ManagedLedgerPayloadProcessor;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerInterceptorImpl
implements ManagedLedgerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerInterceptorImpl.class);
    private static final String INDEX = "index";
    private final Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors;
    private final Set<ManagedLedgerPayloadProcessor.Processor> inputProcessors;
    private final Set<ManagedLedgerPayloadProcessor.Processor> outputProcessors;

    public ManagedLedgerInterceptorImpl(Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors, Set<ManagedLedgerPayloadProcessor> brokerEntryPayloadProcessors) {
        this.brokerEntryMetadataInterceptors = brokerEntryMetadataInterceptors;
        if (brokerEntryPayloadProcessors != null) {
            this.inputProcessors = new LinkedHashSet<ManagedLedgerPayloadProcessor.Processor>();
            this.outputProcessors = new LinkedHashSet<ManagedLedgerPayloadProcessor.Processor>();
            for (ManagedLedgerPayloadProcessor processor : brokerEntryPayloadProcessors) {
                this.inputProcessors.add(processor.inputProcessor());
                this.outputProcessors.add(processor.outputProcessor());
            }
        } else {
            this.inputProcessors = null;
            this.outputProcessors = null;
        }
    }

    public long getIndex() {
        long index = -1L;
        for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
            if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
            index = ((AppendIndexMetadataInterceptor)interceptor).getIndex();
            break;
        }
        return index;
    }

    public OpAddEntry beforeAddEntry(OpAddEntry op, int numberOfMessages) {
        if (op == null || numberOfMessages <= 0) {
            return op;
        }
        op.setData(Commands.addBrokerEntryMetadata((ByteBuf)op.getData(), this.brokerEntryMetadataInterceptors, (int)numberOfMessages));
        return op;
    }

    public void afterFailedAddEntry(int numberOfMessages) {
        for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
            if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
            ((AppendIndexMetadataInterceptor)interceptor).decreaseWithNumberOfMessages(numberOfMessages);
        }
    }

    public void onManagedLedgerPropertiesInitialize(Map<String, String> propertiesMap) {
        if (propertiesMap == null || propertiesMap.size() == 0) {
            return;
        }
        if (propertiesMap.containsKey(INDEX)) {
            for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
                if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
                ((AppendIndexMetadataInterceptor)interceptor).recoveryIndexGenerator(Long.parseLong(propertiesMap.get(INDEX)));
                break;
            }
        }
    }

    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String name, LedgerHandle lh) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        boolean hasAppendIndexMetadataInterceptor = this.brokerEntryMetadataInterceptors.stream().anyMatch(interceptor -> interceptor instanceof AppendIndexMetadataInterceptor);
        if (hasAppendIndexMetadataInterceptor && lh.getLastAddConfirmed() >= 0L) {
            lh.readAsync(lh.getLastAddConfirmed(), lh.getLastAddConfirmed()).whenComplete((entries, ex) -> {
                if (ex != null) {
                    log.error("[{}] Read last entry error.", (Object)name, ex);
                    promise.completeExceptionally((Throwable)ex);
                } else if (entries != null) {
                    try {
                        LedgerEntry ledgerEntry = entries.getEntry(lh.getLastAddConfirmed());
                        if (ledgerEntry != null) {
                            BrokerEntryMetadata brokerEntryMetadata = Commands.parseBrokerEntryMetadataIfExist((ByteBuf)ledgerEntry.getEntryBuffer());
                            for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
                                if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
                                if (brokerEntryMetadata == null || !brokerEntryMetadata.hasIndex()) break;
                                ((AppendIndexMetadataInterceptor)interceptor).recoveryIndexGenerator(brokerEntryMetadata.getIndex());
                                break;
                            }
                        }
                        entries.close();
                        promise.complete(null);
                    }
                    catch (Exception e) {
                        entries.close();
                        log.error("[{}] Failed to recover the index generator from the last add confirmed entry.", (Object)name, (Object)e);
                        promise.completeExceptionally(e);
                    }
                } else {
                    promise.complete(null);
                }
            });
        } else {
            promise.complete(null);
        }
        return promise;
    }

    public void onUpdateManagedLedgerInfo(Map<String, String> propertiesMap) {
        for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
            if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
            propertiesMap.put(INDEX, String.valueOf(((AppendIndexMetadataInterceptor)interceptor).getIndex()));
            break;
        }
    }

    private ManagedLedgerInterceptor.PayloadProcessorHandle processPayload(Set<ManagedLedgerPayloadProcessor.Processor> processors, Object context, ByteBuf payload) {
        ByteBuf tmpData = payload;
        final LinkedHashSet<ImmutablePair> processedSet = new LinkedHashSet<ImmutablePair>();
        for (ManagedLedgerPayloadProcessor.Processor payloadProcessor : processors) {
            if (payloadProcessor == null) continue;
            tmpData = payloadProcessor.process(context, tmpData);
            processedSet.add(new ImmutablePair((Object)payloadProcessor, (Object)tmpData));
        }
        final ByteBuf dataToReturn = tmpData;
        return new ManagedLedgerInterceptor.PayloadProcessorHandle(){

            public ByteBuf getProcessedPayload() {
                return dataToReturn;
            }

            public void release() {
                for (ImmutablePair p : processedSet) {
                    ((ManagedLedgerPayloadProcessor.Processor)p.left).release((ByteBuf)p.right);
                }
                processedSet.clear();
            }
        };
    }

    public ManagedLedgerInterceptor.PayloadProcessorHandle processPayloadBeforeLedgerWrite(OpAddEntry op, ByteBuf ledgerData) {
        if (this.inputProcessors == null || this.inputProcessors.size() == 0) {
            return null;
        }
        return this.processPayload(this.inputProcessors, op.getCtx(), ledgerData);
    }

    public ManagedLedgerInterceptor.PayloadProcessorHandle processPayloadBeforeEntryCache(ByteBuf ledgerData) {
        if (this.outputProcessors == null || this.outputProcessors.size() == 0) {
            return null;
        }
        return this.processPayload(this.outputProcessors, null, ledgerData);
    }
}

