/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.server.model.OperationTimeoutException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class FutureHelper {
    public static <T, E extends Exception> T await(Future<T> future, long timeout, TimeUnit timeUnit) throws OperationTimeoutException, CancellationException, E {
        try {
            if (timeout > 0L) {
                return future.get(timeout, timeUnit);
            }
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServerScopedRuntimeException("Future execution was interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            try {
                throw (Exception)cause;
            }
            catch (ClassCastException cce) {
                throw new ServerScopedRuntimeException("Future failed", cause);
            }
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException(e);
        }
    }

    public static <T, E extends Exception> T await(Future<T> future) throws OperationTimeoutException, CancellationException, E {
        return FutureHelper.await(future, 0L, null);
    }
}

