/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport;

import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class SessionError
implements ErrorCondition,
RestrictedType<Symbol> {
    public static final SessionError WINDOW_VIOLATION = new SessionError(Symbol.valueOf("amqp:session:window-violation"));
    public static final SessionError ERRANT_LINK = new SessionError(Symbol.valueOf("amqp:session:errant-link"));
    public static final SessionError HANDLE_IN_USE = new SessionError(Symbol.valueOf("amqp:session:handle-in-use"));
    public static final SessionError UNATTACHED_HANDLE = new SessionError(Symbol.valueOf("amqp:session:unattached-handle"));
    private final Symbol _val;

    private SessionError(Symbol val) {
        this._val = val;
    }

    public static SessionError valueOf(Object obj) {
        if (obj instanceof Symbol) {
            Symbol val = (Symbol)obj;
            if (SessionError.WINDOW_VIOLATION._val.equals(val)) {
                return WINDOW_VIOLATION;
            }
            if (SessionError.ERRANT_LINK._val.equals(val)) {
                return ERRANT_LINK;
            }
            if (SessionError.HANDLE_IN_USE._val.equals(val)) {
                return HANDLE_IN_USE;
            }
            if (SessionError.UNATTACHED_HANDLE._val.equals(val)) {
                return UNATTACHED_HANDLE;
            }
        }
        String message = String.format("Cannot convert '%s' into 'session-error'", obj);
        throw new IllegalArgumentException(message);
    }

    @Override
    public Symbol getValue() {
        return this._val;
    }

    public String toString() {
        if (this == WINDOW_VIOLATION) {
            return "window-violation";
        }
        if (this == ERRANT_LINK) {
            return "errant-link";
        }
        if (this == HANDLE_IN_USE) {
            return "handle-in-use";
        }
        if (this == UNATTACHED_HANDLE) {
            return "unattached-handle";
        }
        return String.valueOf(this._val);
    }
}

