/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ModelRoot;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferencesRoot;

@ManagedObject(creatable=false)
public interface SystemConfig<X extends SystemConfig<X>>
extends ConfiguredObject<X>,
ModelRoot,
PreferencesRoot,
EventLoggerProvider {
    public static final String MANAGEMENT_MODE = "managementMode";
    public static final String MANAGEMENT_MODE_QUIESCE_VIRTUAL_HOSTS = "managementModeQuiesceVirtualHosts";
    public static final String MANAGEMENT_MODE_HTTP_PORT_OVERRIDE = "managementModeHttpPortOverride";
    public static final String MANAGEMENT_MODE_PASSWORD = "managementModePassword";
    public static final String INITIAL_CONFIGURATION_LOCATION = "initialConfigurationLocation";
    public static final String INITIAL_SYSTEM_PROPERTIES_LOCATION = "initialSystemPropertiesLocation";
    public static final String STARTUP_LOGGED_TO_SYSTEM_OUT = "startupLoggedToSystemOut";
    public static final String PROPERTY_QPID_WORK = "QPID_WORK";
    @ManagedContextDefault(name="QPID_WORK")
    public static final String DEFAULT_QPID_WORK = "${user.dir}${file.separator}work";
    public static final String QPID_WORK_DIR = "qpid.work_dir";
    @ManagedContextDefault(name="qpid.work_dir")
    public static final String DEFAULT_QPID_WORK_DIR = "${QPID_WORK}";
    @ManagedContextDefault(name="qpid.broker.defaultPreferenceStoreAttributes")
    public static final String DEFAULT_PREFERENCE_STORE_ATTRIBUTES = "{\"type\": \"JSON\", \"attributes\":{\"path\": \"${json:qpid.work_dir}${json:file.separator}preferences.json\"}}";
    public static final String POSIX_FILE_PERMISSIONS = "qpid.default_posix_file_permissions";
    @ManagedContextDefault(name="qpid.default_posix_file_permissions")
    public static final String DEFAULT_POSIX_FILE_PERMISSIONS = "rw-r-----";
    public static final String MANAGEMENT_MODE_USER_NAME = "mm_admin";
    public static final String PROPERTY_STATUS_UPDATES = "qpid.broker_status_updates";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "initial-config.json";
    @ManagedContextDefault(name="qpid.initialConfigurationLocation")
    public static final String DEFAULT_INITIAL_CONFIG_LOCATION = "classpath:initial-config.json";

    @ManagedAttribute(immutable=true, defaultValue="Broker")
    public String getDefaultContainerType();

    @ManagedAttribute(defaultValue="false")
    public boolean isManagementMode();

    @ManagedAttribute(defaultValue="0")
    public int getManagementModeHttpPortOverride();

    @ManagedAttribute(defaultValue="false")
    public boolean isManagementModeQuiesceVirtualHosts();

    @ManagedAttribute(secure=true)
    public String getManagementModePassword();

    @ManagedAttribute(defaultValue="${qpid.initialConfigurationLocation}")
    public String getInitialConfigurationLocation();

    @ManagedAttribute
    public String getInitialSystemPropertiesLocation();

    @ManagedAttribute(defaultValue="true")
    public boolean isStartupLoggedToSystemOut();

    @ManagedAttribute(description="Configuration for the preference store, e.g. type, path, etc.", defaultValue="${qpid.broker.defaultPreferenceStoreAttributes}")
    public PreferenceStoreAttributes getPreferenceStoreAttributes();

    @Override
    public EventLogger getEventLogger();

    public Container<?> getContainer();

    public DurableConfigurationStore getConfigurationStore();

    public Runnable getOnContainerResolveTask();

    public void setOnContainerResolveTask(Runnable var1);

    public Runnable getOnContainerCloseTask();

    public void setOnContainerCloseTask(Runnable var1);

    public <T extends Container<? extends T>> T getContainer(Class<T> var1);
}

