/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ext.javatime.ser.JSR310FormattedSerializerBase;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import tools.jackson.databind.jsontype.TypeSerializer;

public class LocalDateSerializer
extends JSR310FormattedSerializerBase<LocalDate> {
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();

    protected LocalDateSerializer() {
        super(LocalDate.class);
    }

    protected LocalDateSerializer(LocalDateSerializer base, DateTimeFormatter dtf, Boolean useTimestamp, JsonFormat.Shape shape) {
        super(base, dtf, useTimestamp, null, shape);
    }

    public LocalDateSerializer(DateTimeFormatter formatter) {
        super(LocalDate.class, formatter);
    }

    protected LocalDateSerializer withFormat(DateTimeFormatter dtf, Boolean useTimestamp, JsonFormat.Shape shape) {
        return new LocalDateSerializer(this, dtf, useTimestamp, shape);
    }

    @Override
    public void serialize(LocalDate date, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this.useTimestamp(ctxt)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                g.writeNumber(date.toEpochDay());
            } else {
                g.writeStartArray();
                this._serializeAsArrayContents(date, g, ctxt);
                g.writeEndArray();
            }
        } else {
            g.writeString(this._formatter == null ? date.toString() : date.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(LocalDate value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        JsonToken shape;
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, this.serializationShape(ctxt)));
        JsonToken jsonToken = shape = typeIdDef == null ? null : typeIdDef.valueShape;
        if (shape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value, g, ctxt);
        } else if (shape == JsonToken.VALUE_NUMBER_INT) {
            g.writeNumber(value.toEpochDay());
        } else {
            g.writeString(this._formatter == null ? value.toString() : value.format(this._formatter));
        }
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected void _serializeAsArrayContents(LocalDate value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        g.writeNumber(value.getYear());
        g.writeNumber(value.getMonthValue());
        g.writeNumber(value.getDayOfMonth());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        boolean useTimestamp;
        SerializationContext ctxt = visitor.getContext();
        boolean bl = useTimestamp = ctxt != null && this.useTimestamp(ctxt);
        if (useTimestamp) {
            this._acceptTimestampVisitor(visitor, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializationContext ctxt) {
        if (this.useTimestamp(ctxt)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.START_ARRAY;
        }
        return JsonToken.VALUE_STRING;
    }
}

