/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.rep.impl.RepParams;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentConfiguration;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentFacade;

public class StandardEnvironmentFacadeFactory
implements EnvironmentFacadeFactory {
    @Override
    public EnvironmentFacade createEnvironmentFacade(final ConfiguredObject<?> parent) {
        FileBasedSettings settings = (FileBasedSettings)parent;
        final String storeLocation = settings.getStorePath();
        StandardEnvironmentConfiguration sec = new StandardEnvironmentConfiguration(){

            @Override
            public String getName() {
                return parent.getName();
            }

            @Override
            public String getStorePath() {
                return storeLocation;
            }

            @Override
            public CacheMode getCacheMode() {
                return BDBUtils.getCacheMode(parent);
            }

            @Override
            public Map<String, String> getParameters() {
                return BDBUtils.getEnvironmentConfigurationParameters(parent);
            }

            @Override
            public <T> T getFacadeParameter(Class<T> clazz, String parameterName, T defaultValue) {
                return BDBUtils.getContextValue(parent, clazz, parameterName, defaultValue);
            }

            @Override
            public <T> T getFacadeParameter(Class<T> paremeterClass, Type type, String parameterName, T defaultValue) {
                return BDBUtils.getContextValue(parent, paremeterClass, type, parameterName, defaultValue);
            }
        };
        return new StandardEnvironmentFacade(sec);
    }

    static {
        RepParams.GROUP_NAME.getName();
    }
}

