/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.ServerMessageMutator;
import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.MessageStore;

public interface ServerMessageMutatorFactory<T extends ServerMessage>
extends Pluggable {
    public ServerMessageMutator<T> create(T var1, MessageStore var2);

    public static <T extends ServerMessage> ServerMessageMutator<T> createMutator(T serverMessage, MessageStore messageStore) {
        ServerMessageMutatorFactory factory = ServerMessageMutatorFactoryRegistry.get(serverMessage.getClass().getName());
        if (factory == null) {
            throw new IllegalStateException(String.format("Cannot find server message mutator for message class '%s'", serverMessage.getClass().getName()));
        }
        return factory.create(serverMessage, messageStore);
    }

    public static class ServerMessageMutatorFactoryRegistry {
        private static final Map<String, ServerMessageMutatorFactory> MUTATOR_FACTORIES = StreamSupport.stream(new QpidServiceLoader().instancesOf(ServerMessageMutatorFactory.class).spliterator(), false).collect(Collectors.toMap(Pluggable::getType, i -> i));

        private static ServerMessageMutatorFactory get(String type) {
            return MUTATOR_FACTORIES.get(type);
        }
    }
}

