/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.TypeEncoding;

public abstract class AbstractDescribedType<T, M>
implements AMQPType<T> {
    private final DecoderImpl _decoder;
    private final EncoderImpl _encoder;
    private final Map<TypeEncoding<M>, TypeEncoding<T>> _encodings = new HashMap<TypeEncoding<M>, TypeEncoding<T>>();

    public AbstractDescribedType(EncoderImpl encoder) {
        this._encoder = encoder;
        this._decoder = encoder.getDecoder();
    }

    protected abstract UnsignedLong getDescriptor();

    public EncoderImpl getEncoder() {
        return this._encoder;
    }

    public DecoderImpl getDecoder() {
        return this._decoder;
    }

    @Override
    public TypeEncoding<T> getEncoding(T val) {
        M asUnderlying = this.wrap(val);
        TypeEncoding<M> underlyingEncoding = this._encoder.getType(asUnderlying).getEncoding(asUnderlying);
        DynamicDescribedTypeEncoding encoding = this._encodings.get(underlyingEncoding);
        if (encoding == null) {
            encoding = new DynamicDescribedTypeEncoding(underlyingEncoding);
            this._encodings.put(underlyingEncoding, encoding);
        }
        return encoding;
    }

    protected abstract M wrap(T var1);

    @Override
    public TypeEncoding<T> getCanonicalEncoding() {
        return null;
    }

    @Override
    public Collection<TypeEncoding<T>> getAllEncodings() {
        Collection<TypeEncoding<T>> values = this._encodings.values();
        Collection<TypeEncoding<T>> unmodifiable = Collections.unmodifiableCollection(values);
        return unmodifiable;
    }

    @Override
    public void write(T val) {
        TypeEncoding<T> encoding = this.getEncoding(val);
        encoding.writeConstructor();
        encoding.writeValue(val);
    }

    private class DynamicDescribedTypeEncoding
    implements TypeEncoding<T> {
        private final TypeEncoding<M> _underlyingEncoding;
        private final TypeEncoding<UnsignedLong> _descriptorType;
        private final int _constructorSize;

        public DynamicDescribedTypeEncoding(TypeEncoding<M> underlyingEncoding) {
            this._underlyingEncoding = underlyingEncoding;
            this._descriptorType = AbstractDescribedType.this._encoder.getType(AbstractDescribedType.this.getDescriptor()).getEncoding(AbstractDescribedType.this.getDescriptor());
            this._constructorSize = 1 + this._descriptorType.getConstructorSize() + this._descriptorType.getValueSize(AbstractDescribedType.this.getDescriptor()) + this._underlyingEncoding.getConstructorSize();
        }

        @Override
        public AMQPType<T> getType() {
            return AbstractDescribedType.this;
        }

        @Override
        public void writeConstructor() {
            AbstractDescribedType.this._encoder.writeRaw((byte)0);
            this._descriptorType.writeConstructor();
            this._descriptorType.writeValue(AbstractDescribedType.this.getDescriptor());
            this._underlyingEncoding.writeConstructor();
        }

        @Override
        public int getConstructorSize() {
            return this._constructorSize;
        }

        @Override
        public void writeValue(T val) {
            this._underlyingEncoding.writeValue(AbstractDescribedType.this.wrap(val));
        }

        @Override
        public int getValueSize(T val) {
            return this._underlyingEncoding.getValueSize(AbstractDescribedType.this.wrap(val));
        }

        @Override
        public boolean isFixedSizeVal() {
            return this._underlyingEncoding.isFixedSizeVal();
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<T> encoding) {
            return this.getType() == encoding.getType() && this._underlyingEncoding.encodesSuperset(((DynamicDescribedTypeEncoding)encoding)._underlyingEncoding);
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return false;
        }
    }
}

