/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlSyncFullSchemaProperty;
import com.microsoft.azure.management.sql.SqlSyncGroup;
import com.microsoft.azure.management.sql.SqlSyncMember;
import com.microsoft.azure.management.sql.SqlSyncMemberOperations;
import com.microsoft.azure.management.sql.SyncDirection;
import com.microsoft.azure.management.sql.SyncMemberDbType;
import com.microsoft.azure.management.sql.SyncMemberState;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlSyncFullSchemaPropertyImpl;
import com.microsoft.azure.management.sql.implementation.SqlSyncGroupImpl;
import com.microsoft.azure.management.sql.implementation.SyncFullSchemaPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncMemberInner;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlSyncMemberImpl
extends ExternalChildResourceImpl<SqlSyncMember, SyncMemberInner, SqlSyncGroupImpl, SqlSyncGroup>
implements SqlSyncMember,
SqlSyncMember.Update,
SqlSyncMemberOperations.SqlSyncMemberOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private String sqlSyncGroupName;

    SqlSyncMemberImpl(String name, SqlSyncGroupImpl parent, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.sqlDatabaseName();
        this.sqlSyncGroupName = parent.name();
    }

    SqlSyncMemberImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, String sqlSyncGroupName, String name, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
        this.sqlSyncGroupName = sqlSyncGroupName;
    }

    SqlSyncMemberImpl(String name, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().parent().parent().name();
                this.sqlDatabaseName = resourceId.parent().parent().name();
                this.sqlSyncGroupName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((SyncMemberInner)this.inner()).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String sqlDatabaseName() {
        return this.sqlDatabaseName;
    }

    @Override
    public String sqlSyncGroupName() {
        return this.sqlSyncGroupName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((SyncMemberInner)this.inner()).id());
    }

    @Override
    public SyncMemberDbType databaseType() {
        return ((SyncMemberInner)this.inner()).databaseType();
    }

    @Override
    public String syncAgentId() {
        return ((SyncMemberInner)this.inner()).syncAgentId();
    }

    @Override
    public String sqlServerDatabaseId() {
        return ((SyncMemberInner)this.inner()).sqlServerDatabaseId().toString();
    }

    @Override
    public String memberServerName() {
        return ((SyncMemberInner)this.inner()).serverName();
    }

    @Override
    public String memberDatabaseName() {
        return ((SyncMemberInner)this.inner()).databaseName();
    }

    @Override
    public String userName() {
        return ((SyncMemberInner)this.inner()).userName();
    }

    @Override
    public SyncDirection syncDirection() {
        return ((SyncMemberInner)this.inner()).syncDirection();
    }

    @Override
    public SyncMemberState syncState() {
        return ((SyncMemberInner)this.inner()).syncState();
    }

    public Observable<SqlSyncMember> createResourceAsync() {
        final SqlSyncMemberImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name(), (SyncMemberInner)this.inner()).map((Func1)new Func1<SyncMemberInner, SqlSyncMember>(){

            public SqlSyncMember call(SyncMemberInner syncMemberInner) {
                self.setInner(syncMemberInner);
                return self;
            }
        });
    }

    public Observable<SqlSyncMember> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().deleteAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    protected Observable<SyncMemberInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().delete(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    public SqlSyncMember.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    @Override
    public PagedList<SqlSyncFullSchemaProperty> listMemberSchemas() {
        PagedListConverter<SyncFullSchemaPropertiesInner, SqlSyncFullSchemaProperty> converter = new PagedListConverter<SyncFullSchemaPropertiesInner, SqlSyncFullSchemaProperty>(){

            public Observable<SqlSyncFullSchemaProperty> typeConvertAsync(SyncFullSchemaPropertiesInner inner) {
                return Observable.just((Object)new SqlSyncFullSchemaPropertyImpl(inner));
            }
        };
        return converter.convert(((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().listMemberSchemas(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()));
    }

    @Override
    public Observable<SqlSyncFullSchemaProperty> listMemberSchemasAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().listMemberSchemasAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()).flatMap((Func1)new Func1<Page<SyncFullSchemaPropertiesInner>, Observable<SyncFullSchemaPropertiesInner>>(){

            public Observable<SyncFullSchemaPropertiesInner> call(Page<SyncFullSchemaPropertiesInner> syncFullSchemaPropertiesInnerPage) {
                return Observable.from((Iterable)syncFullSchemaPropertiesInnerPage.items());
            }
        }).map((Func1)new Func1<SyncFullSchemaPropertiesInner, SqlSyncFullSchemaProperty>(){

            public SqlSyncFullSchemaProperty call(SyncFullSchemaPropertiesInner syncFullSchemaPropertiesInner) {
                return new SqlSyncFullSchemaPropertyImpl(syncFullSchemaPropertiesInner);
            }
        });
    }

    @Override
    public void refreshMemberSchema() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().refreshMemberSchema(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public Completable refreshMemberSchemaAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().refreshMemberSchemaAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()).toCompletable();
    }

    @Override
    public SqlSyncMemberImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingSyncGroup(SqlSyncGroup sqlSyncGroup) {
        this.resourceGroupName = sqlSyncGroup.resourceGroupName();
        this.sqlServerName = sqlSyncGroup.sqlServerName();
        this.sqlDatabaseName = sqlSyncGroup.sqlDatabaseName();
        this.sqlSyncGroupName = sqlSyncGroup.name();
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingDatabaseName(String databaseName) {
        this.sqlDatabaseName = databaseName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberUserName(String userName) {
        ((SyncMemberInner)this.inner()).withUserName(userName);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingSyncGroupName(String syncGroupName) {
        this.sqlSyncGroupName = syncGroupName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberPassword(String password) {
        ((SyncMemberInner)this.inner()).withPassword(password);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlServerName(String sqlServerName) {
        ((SyncMemberInner)this.inner()).withServerName(sqlServerName);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlDatabase(SqlDatabase sqlDatabase) {
        ((SyncMemberInner)this.inner()).withServerName(sqlDatabase.sqlServerName());
        ((SyncMemberInner)this.inner()).withDatabaseName(sqlDatabase.name());
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberDatabaseType(SyncMemberDbType databaseType) {
        ((SyncMemberInner)this.inner()).withDatabaseType(databaseType);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withDatabaseType(SyncDirection syncDirection) {
        ((SyncMemberInner)this.inner()).withSyncDirection(syncDirection);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlDatabaseName(String sqlDatabaseName) {
        ((SyncMemberInner)this.inner()).withDatabaseName(sqlDatabaseName);
        return this;
    }
}

