/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.metrics.impl.RatisObjectNameFactory;
import org.apache.ratis.thirdparty.com.codahale.metrics.ConsoleReporter;
import org.apache.ratis.thirdparty.com.codahale.metrics.ScheduledReporter;
import org.apache.ratis.thirdparty.com.codahale.metrics.jmx.JmxReporter;
import org.apache.ratis.util.TimeDuration;

final class MetricsReporting {
    private MetricsReporting() {
    }

    static Consumer<RatisMetricRegistry> consoleReporter(TimeDuration rate) {
        return registry -> MetricsReporting.consoleReporter(rate, registry);
    }

    private static void consoleReporter(TimeDuration rate, RatisMetricRegistry registry) {
        RatisMetricRegistryImpl impl = RatisMetricRegistryImpl.cast(registry);
        ConsoleReporter reporter = ConsoleReporter.forRegistry(impl.getDropWizardMetricRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(rate.getDuration(), rate.getUnit());
        impl.setConsoleReporter(reporter);
    }

    static Consumer<RatisMetricRegistry> stopConsoleReporter() {
        return MetricsReporting::stopConsoleReporter;
    }

    private static void stopConsoleReporter(RatisMetricRegistry registry) {
        RatisMetricRegistryImpl impl = RatisMetricRegistryImpl.cast(registry);
        Optional.ofNullable(impl.getConsoleReporter()).ifPresent(ScheduledReporter::close);
    }

    static Consumer<RatisMetricRegistry> jmxReporter() {
        return MetricsReporting::jmxReporter;
    }

    private static void jmxReporter(RatisMetricRegistry registry) {
        RatisMetricRegistryImpl impl = RatisMetricRegistryImpl.cast(registry);
        JmxReporter reporter = JmxReporter.forRegistry(impl.getDropWizardMetricRegistry()).inDomain(registry.getMetricRegistryInfo().getApplicationName()).createsObjectNamesWith(new RatisObjectNameFactory()).build();
        reporter.start();
        impl.setJmxReporter(reporter);
    }

    static Consumer<RatisMetricRegistry> stopJmxReporter() {
        return MetricsReporting::stopJmxReporter;
    }

    private static void stopJmxReporter(RatisMetricRegistry registry) {
        RatisMetricRegistryImpl impl = RatisMetricRegistryImpl.cast(registry);
        Optional.ofNullable(impl.getJmxReporter()).ifPresent(JmxReporter::close);
    }
}

