/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.util.Collections;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;

final class LeaderProtoUtils {
    private LeaderProtoUtils() {
    }

    static RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.Builder toSnapshotChunkProtoBuilder(String requestId, int requestIndex, TermIndex lastTermIndex, RaftProtos.FileChunkProto chunk, long totalSize, boolean done) {
        return RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.newBuilder().setRequestId(requestId).setRequestIndex(requestIndex).setTermIndex(lastTermIndex.toProto()).addAllFileChunks(Collections.singleton(chunk)).setTotalSize(totalSize).setDone(done);
    }

    static RaftProtos.InstallSnapshotRequestProto toInstallSnapshotRequestProto(RaftServer.Division server, RaftPeerId replyId, RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.Builder chunk) {
        return LeaderProtoUtils.toInstallSnapshotRequestProtoBuilder(server, replyId).setSnapshotChunk(chunk).build();
    }

    static RaftProtos.InstallSnapshotRequestProto toInstallSnapshotRequestProto(RaftServer.Division server, RaftPeerId replyId, TermIndex firstAvailable) {
        return LeaderProtoUtils.toInstallSnapshotRequestProtoBuilder(server, replyId).setNotification(RaftProtos.InstallSnapshotRequestProto.NotificationProto.newBuilder().setFirstAvailableTermIndex(firstAvailable.toProto())).build();
    }

    private static RaftProtos.InstallSnapshotRequestProto.Builder toInstallSnapshotRequestProtoBuilder(RaftServer.Division server, RaftPeerId replyId) {
        RaftConfiguration conf = server.getRaftConf();
        RaftProtos.LogEntryProto confLogEntryProto = LogProtoUtils.toLogEntryProto(conf, null, conf.getLogEntryIndex());
        return RaftProtos.InstallSnapshotRequestProto.newBuilder().setServerRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(server.getMemberId(), replyId)).setLeaderTerm(server.getInfo().getCurrentTerm()).setLastRaftConfigurationLogEntryProto(confLogEntryProto);
    }
}

