/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.localization.LocalizationManager;
import flash.tools.debugger.AIRLaunchInfo;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.DefaultDebuggerCallbacks;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.ILaunchNotification;
import flash.tools.debugger.ILauncher;
import flash.tools.debugger.IProgress;
import flash.tools.debugger.Player;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager2;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.concrete.AIRPlayer;
import flash.tools.debugger.concrete.ActiveXPlayer;
import flash.tools.debugger.concrete.NetscapePluginPlayer;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.ProcessListener;
import flash.tools.debugger.concrete.StandalonePlayer;
import flash.util.URLHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PlayerSessionManager
implements SessionManager2 {
    private ServerSocket m_serverSocket = null;
    private HashMap<String, Object> m_prefs;
    private IDebuggerCallbacks m_debuggerCallbacks = new DefaultDebuggerCallbacks();
    private static LocalizationManager m_localizationManager = new LocalizationManager();
    private Socket m_connectSocket = null;
    private boolean m_cancelConnect = false;

    public PlayerSessionManager() {
        this.m_prefs = new HashMap();
        this.setPreference("$accepttimeout", 120000);
        this.setPreference("$urimodification", 1);
        this.setPreference("$connecttimeout", 120000);
        this.setPreference("$connectwaitinterval", 250);
        this.setPreference("$connectretryattempts", -1);
        this.setPreference("$sockettimeout", -1);
        this.setPreference("$responsetimeout", 750);
        this.setPreference("$contextresponsetimeout", 1000);
        this.setPreference("$getvarresponsetimeout", 1500);
        this.setPreference("$setvarresponsetimeout", 5000);
        this.setPreference("$swfswdloadtimeout", 5000);
        this.setPreference("$suspendwait", 7000);
        this.setPreference("$invokegetters", 1);
        this.setPreference("$hiervars", 0);
    }

    @Override
    public void setPreference(String string, int n) {
        this.m_prefs.put(string, n);
    }

    @Override
    public void setPreference(String string, String string2) {
        this.m_prefs.put(string, string2);
    }

    public Set<String> keySet() {
        return this.m_prefs.keySet();
    }

    public Object getPreferenceAsObject(String string) {
        return this.m_prefs.get(string);
    }

    @Override
    public int getPreference(String string) {
        int n = 0;
        Integer n2 = (Integer)this.m_prefs.get(string);
        if (n2 == null) {
            throw new NullPointerException();
        }
        n = n2;
        return n;
    }

    @Override
    public void startListening() throws IOException {
        if (this.m_serverSocket == null) {
            this.m_serverSocket = new ServerSocket(7935);
        }
    }

    @Override
    public void stopListening() throws IOException {
        if (this.m_serverSocket != null) {
            this.m_serverSocket.close();
            this.m_serverSocket = null;
        }
    }

    @Override
    public boolean isListening() {
        return this.m_serverSocket != null;
    }

    private OS getOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os x")) {
            return OS.Mac;
        }
        if (string.startsWith("windows")) {
            return OS.Windows;
        }
        return OS.Unix;
    }

    @Override
    public Session launch(String string, AIRLaunchInfo aIRLaunchInfo, boolean bl, IProgress iProgress, ILaunchNotification iLaunchNotification) throws IOException {
        String[] stringArray = this.getLaunchCommand(string, aIRLaunchInfo, bl);
        Process process = this.m_debuggerCallbacks.launchDebugTarget(stringArray);
        ProcessListener processListener = this.startProcessListener(aIRLaunchInfo, bl, iLaunchNotification, stringArray, process, false);
        PlayerSession playerSession = null;
        if (bl) {
            playerSession = this.waitForConnection(string, aIRLaunchInfo, iProgress, process, processListener);
        }
        return playerSession;
    }

    private PlayerSession waitForConnection(String string, AIRLaunchInfo aIRLaunchInfo, IProgress iProgress, Process process, ProcessListener processListener) throws IOException {
        PlayerSession playerSession = (PlayerSession)this.accept(processListener, iProgress);
        playerSession.setProcess(process);
        playerSession.setLaunchUrl(string);
        playerSession.setAIRLaunchInfo(aIRLaunchInfo);
        return playerSession;
    }

    private String tweakNativeLaunchUri(String string, boolean bl, LaunchInfo launchInfo) throws IOException, FileNotFoundException {
        if (launchInfo.isHttpOrAbout()) {
            boolean bl2;
            boolean bl3 = bl2 = this.getPreference("$urimodification") != 0;
            if (bl2 && bl && !launchInfo.isAbout()) {
                string = URLHelper.escapeSpace(string);
                URLHelper uRLHelper = new URLHelper(string);
                LinkedHashMap<String, String> linkedHashMap = uRLHelper.getParameterMap();
                linkedHashMap.put("debug", "true");
                uRLHelper.setParameterMap(linkedHashMap);
                string = uRLHelper.getURL();
            }
        } else {
            File file = null;
            if (string.startsWith("file:")) {
                try {
                    file = new File(new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    IOException iOException = new IOException(uRISyntaxException.getMessage());
                    iOException.initCause(uRISyntaxException);
                    throw iOException;
                }
            } else {
                file = new File(string);
            }
            if (file.exists()) {
                string = file.getAbsolutePath();
            } else {
                throw new FileNotFoundException(string);
            }
        }
        return string;
    }

    private String[] getFlashLaunchArgs(String string, LaunchInfo launchInfo) throws FileNotFoundException {
        String[] stringArray;
        OS oS = this.getOS();
        if (oS == OS.Mac) {
            if (launchInfo.isWebBrowserNativeLaunch()) {
                File file = this.m_debuggerCallbacks.getHttpExe();
                String[] stringArray2 = this.m_debuggerCallbacks.getBrowserParameters(string);
                if (stringArray2 == null) {
                    stringArray = new String[]{"/usr/bin/open", "-a", file.toString(), string};
                } else {
                    stringArray = new String[stringArray2.length + 4];
                    stringArray[0] = "/usr/bin/open";
                    stringArray[1] = "-a";
                    stringArray[2] = file.toString();
                    stringArray[3] = "--args";
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray[i + 4] = stringArray2[i];
                    }
                }
            } else if (launchInfo.isPlayerNativeLaunch()) {
                File file = this.m_debuggerCallbacks.getPlayerExe();
                stringArray = new String[]{"/usr/bin/open", "-a", file.toString(), string};
            } else {
                stringArray = new String[]{"/usr/bin/open", string};
            }
        } else if (launchInfo.isWebBrowserNativeLaunch()) {
            File file = this.m_debuggerCallbacks.getHttpExe();
            String[] stringArray3 = this.m_debuggerCallbacks.getBrowserParameters(string);
            if (stringArray3 == null) {
                stringArray = oS == OS.Windows ? this.getWindowsBrowserLaunchArgs(file, string) : new String[]{file.toString(), string};
            } else {
                stringArray = new String[stringArray3.length + 1];
                stringArray[0] = file.toString();
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray[i + 1] = stringArray3[i];
                }
            }
        } else if (launchInfo.isPlayerNativeLaunch()) {
            File file = this.m_debuggerCallbacks.getPlayerExe();
            stringArray = new String[]{file.toString(), string};
        } else if (oS == OS.Windows) {
            string = string.replaceAll("&", "\"&\"");
            stringArray = new String[]{"cmd", "/c", "start", string};
        } else {
            String string2 = launchInfo.isWebPage() ? this.m_debuggerCallbacks.getHttpExeName() : this.m_debuggerCallbacks.getPlayerExeName();
            throw new FileNotFoundException(string2);
        }
        return stringArray;
    }

    private String[] getWindowsBrowserLaunchArgs(File file, String string) {
        if (file.getName().equalsIgnoreCase("chrome.exe")) {
            return new String[]{file.toString(), "--disable-hang-monitor", string};
        }
        if (file.getName().equalsIgnoreCase("iexplore.exe")) {
            boolean bl = false;
            try {
                int[] nArray = this.m_debuggerCallbacks.getAppVersion(file);
                if (nArray != null) {
                    bl = nArray[0] >= 8;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                return new String[]{file.toString(), "-noframemerging", string};
            }
        }
        return new String[]{file.toString(), string};
    }

    private String[] getAIRLaunchArgs(String string, AIRLaunchInfo aIRLaunchInfo) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(aIRLaunchInfo.airDebugLauncher.getPath());
        if (aIRLaunchInfo.airRuntimeDir != null) {
            linkedList.add("-runtime");
            linkedList.add(aIRLaunchInfo.airRuntimeDir.getPath());
        }
        if (aIRLaunchInfo.airSecurityPolicy != null) {
            linkedList.add("-security-policy");
            linkedList.add(aIRLaunchInfo.airSecurityPolicy.getPath());
        }
        if (aIRLaunchInfo.airPublisherID != null && aIRLaunchInfo.airPublisherID.length() > 0) {
            linkedList.add("-pubid");
            linkedList.add(aIRLaunchInfo.airPublisherID);
        }
        if (aIRLaunchInfo.profile != null && aIRLaunchInfo.profile.length() > 0) {
            linkedList.add("-profile");
            linkedList.add(aIRLaunchInfo.profile);
        }
        if (aIRLaunchInfo.screenSize != null && aIRLaunchInfo.screenSize.length() > 0) {
            linkedList.add("-screensize");
            linkedList.add(aIRLaunchInfo.screenSize);
        }
        if (aIRLaunchInfo.dpi > 0) {
            linkedList.add("-XscreenDPI");
            linkedList.add(String.valueOf(aIRLaunchInfo.dpi));
        }
        if (aIRLaunchInfo.versionPlatform != null && aIRLaunchInfo.versionPlatform.length() > 0) {
            linkedList.add("-XversionPlatform");
            linkedList.add(aIRLaunchInfo.versionPlatform);
        }
        if (aIRLaunchInfo.extDir != null && aIRLaunchInfo.extDir.length() > 0) {
            linkedList.add("-extdir");
            linkedList.add(aIRLaunchInfo.extDir);
        }
        if (aIRLaunchInfo.deviceExtDir != null && aIRLaunchInfo.deviceExtDir.length() > 0) {
            linkedList.add("-XdeviceExtDir");
            linkedList.add(aIRLaunchInfo.deviceExtDir);
        }
        File file = null;
        if (string.startsWith("file:")) {
            try {
                file = new File(new URI(string));
                linkedList.add(file.getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException(uRISyntaxException.getMessage());
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        } else {
            linkedList.add(string);
        }
        if (aIRLaunchInfo.applicationContentRootDir != null) {
            linkedList.add(aIRLaunchInfo.applicationContentRootDir.getAbsolutePath());
        }
        List<String> list = null;
        if (aIRLaunchInfo.applicationArgumentsArray != null) {
            list = Arrays.asList(aIRLaunchInfo.applicationArgumentsArray);
        } else if (aIRLaunchInfo.applicationArguments != null) {
            list = this.splitArgs(aIRLaunchInfo.applicationArguments);
        }
        if (list != null && list.size() > 0) {
            linkedList.add("--");
            linkedList.addAll(list);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private List<String> splitArgs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.trim();
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("win");
        boolean bl2 = !bl;
        int n = 0;
        while (n < string.length()) {
            int n2;
            int n3 = string.charAt(n);
            if (n3 == 32 || n3 == 9) {
                ++n;
                continue;
            }
            if (n3 == 34 || bl2 && n3 == 39) {
                n2 = n3;
                int n4 = string.indexOf(n2, n + 1);
                if (n4 == -1) {
                    arrayList.add(string.substring(n + 1));
                    return arrayList;
                }
                arrayList.add(string.substring(n + 1, n4));
                n = n4 + 1;
                continue;
            }
            n2 = n;
            while (n < string.length() && (n3 = (int)string.charAt(n)) != 32 && n3 != 9) {
                ++n;
            }
            arrayList.add(string.substring(n2, n));
        }
        return arrayList;
    }

    @Override
    public Player playerForUri(String string, AIRLaunchInfo aIRLaunchInfo) {
        LaunchInfo launchInfo = new LaunchInfo(string);
        if (aIRLaunchInfo != null) {
            return new AIRPlayer(aIRLaunchInfo.airDebugLauncher);
        }
        if (launchInfo.isAIRLaunch()) {
            return new AIRPlayer(null);
        }
        if (this.getOS() == OS.Mac) {
            if (!launchInfo.isWebBrowserNativeLaunch()) {
                File file = this.m_debuggerCallbacks.getPlayerExe();
                return new StandalonePlayer(file);
            }
            File file = new File("/Library/Internet Plug-Ins/Flash Player.plugin");
            return new NetscapePluginPlayer(this.m_debuggerCallbacks.getHttpExe(), file);
        }
        if (launchInfo.isWebBrowserNativeLaunch()) {
            File file;
            File file2;
            File file3;
            File file4 = this.m_debuggerCallbacks.getHttpExe();
            if (file4.getName().equalsIgnoreCase("iexplore.exe")) {
                String string2 = null;
                boolean bl = System.getenv("ProgramFiles(x86)") != null;
                try {
                    string2 = bl ? (file4.getCanonicalPath().contains("(x86)") ? this.m_debuggerCallbacks.queryWindowsRegistry("HKEY_CLASSES_ROOT\\CLSID\\{D27CDB6E-AE6D-11cf-96B8-444553540000}\\InprocServer32", null, 1) : this.m_debuggerCallbacks.queryWindowsRegistry("HKEY_CLASSES_ROOT\\CLSID\\{D27CDB6E-AE6D-11cf-96B8-444553540000}\\InprocServer32", null, 2)) : this.m_debuggerCallbacks.queryWindowsRegistry("HKEY_CLASSES_ROOT\\CLSID\\{D27CDB6E-AE6D-11cf-96B8-444553540000}\\InprocServer32", null, 1);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (string2 == null) {
                    return null;
                }
                File file5 = new File(string2);
                return new ActiveXPlayer(file4, file5);
            }
            File file6 = file4.getParentFile();
            if (file4.getName().equalsIgnoreCase("opera.exe")) {
                file6 = new File(file6, "program");
            }
            if (!(file3 = new File(file2 = new File(file6, "plugins"), "NPSWF32.dll")).exists() && (file = this.getWindowsMozillaPlayerPathFromRegistry()) != null) {
                file3 = file;
            }
            return new NetscapePluginPlayer(file4, file3);
        }
        if (launchInfo.isPlayerNativeLaunch()) {
            File file = this.m_debuggerCallbacks.getPlayerExe();
            return new StandalonePlayer(file);
        }
        return null;
    }

    private File getWindowsMozillaPlayerPathFromRegistry() {
        String[] stringArray = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = this.m_debuggerCallbacks.queryWindowsRegistry(stringArray[i] + "\\SOFTWARE\\MozillaPlugins\\@adobe.com/FlashPlayer", "Path", 1);
                if (string == null) continue;
                return new File(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean supportsLaunch() {
        return true;
    }

    @Override
    public Session accept(IProgress iProgress) throws IOException {
        return this.accept(null, iProgress);
    }

    private Session accept(ProcessListener processListener, IProgress iProgress) throws IOException {
        int n;
        int n2 = n = this.getPreference("$accepttimeout");
        int n3 = 100;
        PlayerSession playerSession = null;
        try {
            this.m_serverSocket.setSoTimeout(n3);
            Socket socket = null;
            while (socket == null && !this.airAppTerminated(processListener)) {
                block6: {
                    try {
                        socket = this.m_serverSocket.accept();
                    }
                    catch (IOException iOException) {
                        if ((n -= n3) >= 0 && this.m_serverSocket != null && !this.m_serverSocket.isClosed()) break block6;
                        throw iOException;
                    }
                }
                if (iProgress == null) continue;
                iProgress.setProgress(n2 - n, n2);
            }
            if (socket == null && this.airAppTerminated(processListener)) {
                throw processListener.createLaunchFailureException();
            }
            playerSession = PlayerSession.createFromSocketWithOptions(socket, this.m_debuggerCallbacks, this);
            playerSession.setPreferences(this.m_prefs);
        }
        catch (NullPointerException nullPointerException) {
            throw new BindException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("serverSocketNotListening"));
        }
        return playerSession;
    }

    private boolean airAppTerminated(ProcessListener processListener) {
        return processListener != null && processListener.isAIRApp() && processListener.isProcessDead();
    }

    public IDebuggerCallbacks getDebuggerCallbacks() {
        return this.m_debuggerCallbacks;
    }

    @Override
    public void setDebuggerCallbacks(IDebuggerCallbacks iDebuggerCallbacks) {
        this.m_debuggerCallbacks = iDebuggerCallbacks;
    }

    @Override
    public Session connect(int n, IProgress iProgress) throws IOException {
        int n2 = this.getPreference("$connectwaitinterval");
        int n3 = this.getPreference("$connectretryattempts");
        int n4 = this.getPreference("$connecttimeout");
        long l = System.currentTimeMillis();
        long l2 = 0L;
        int n5 = -1;
        PlayerSession playerSession = null;
        Socket socket = null;
        this.m_cancelConnect = false;
        while (socket == null) {
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(null), n);
                this.m_connectSocket = socket = new Socket();
                socket.connect(inetSocketAddress, n4);
            }
            catch (IOException iOException) {
                if (iOException instanceof SocketTimeoutException) {
                    this.abortConnect(iOException);
                }
                this.safeCloseSocket(socket);
                socket = null;
                l2 = this.checkConnectTimeout(n2, n3, n4, ++n5, l, iOException);
            }
            if (iProgress != null) {
                iProgress.setProgress((int)l2, n4);
            }
            if (socket == null) continue;
            playerSession = PlayerSession.createFromSocketWithOptions(socket, this.m_debuggerCallbacks, this);
            playerSession.setPreferences(this.m_prefs);
            try {
                playerSession.bind();
            }
            catch (VersionException versionException) {
                playerSession.unbind();
                this.safeCloseSocket(socket);
                socket = null;
                l2 = this.checkConnectTimeout(n2, n3, n4, ++n5, l, new IOException(versionException.getLocalizedMessage()));
            }
        }
        this.m_connectSocket = null;
        return playerSession;
    }

    private long checkConnectTimeout(int n, int n2, int n3, int n4, long l, IOException iOException) throws IOException {
        boolean bl;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        boolean bl2 = bl = n2 != -1 && n4 >= n2;
        if (bl || l3 > (long)n3 || this.m_cancelConnect) {
            this.abortConnect(iOException);
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            this.abortConnect(iOException);
        }
        if (this.m_cancelConnect) {
            this.abortConnect(iOException);
        }
        return l3;
    }

    private void abortConnect(IOException iOException) throws IOException {
        this.m_connectSocket = null;
        this.m_cancelConnect = false;
        throw iOException;
    }

    private void safeCloseSocket(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stopConnecting() throws IOException {
        if (!this.m_cancelConnect) {
            this.m_cancelConnect = true;
            if (this.m_connectSocket != null) {
                this.m_connectSocket.close();
                this.m_connectSocket = null;
            }
        }
    }

    @Override
    public boolean isConnecting() {
        return this.m_connectSocket != null;
    }

    public static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    @Override
    public Process launchForRun(String string, AIRLaunchInfo aIRLaunchInfo, IProgress iProgress, ILaunchNotification iLaunchNotification) throws IOException {
        String[] stringArray = this.getLaunchCommand(string, aIRLaunchInfo, false);
        Process process = this.m_debuggerCallbacks.launchDebugTarget(stringArray);
        this.startProcessListener(aIRLaunchInfo, false, iLaunchNotification, stringArray, process, true);
        return process;
    }

    private ProcessListener startProcessListener(AIRLaunchInfo aIRLaunchInfo, boolean bl, ILaunchNotification iLaunchNotification, String[] stringArray, Process process, boolean bl2) {
        ProcessListener processListener = new ProcessListener(stringArray, process, iLaunchNotification, bl, aIRLaunchInfo != null);
        processListener.setIsRunLaunch(bl2);
        if (!bl && aIRLaunchInfo != null && iLaunchNotification != null) {
            processListener.startLaunchNotifier();
        }
        return processListener;
    }

    private String[] getLaunchCommand(String string, AIRLaunchInfo aIRLaunchInfo, boolean bl) throws IOException, FileNotFoundException {
        String[] stringArray;
        string = string.trim();
        if (aIRLaunchInfo == null) {
            LaunchInfo launchInfo = new LaunchInfo(string);
            string = this.tweakNativeLaunchUri(string, bl, launchInfo);
            stringArray = this.getFlashLaunchArgs(string, launchInfo);
        } else {
            stringArray = this.getAIRLaunchArgs(string, aIRLaunchInfo);
        }
        return stringArray;
    }

    @Override
    public Process launchForRun(String string, AIRLaunchInfo aIRLaunchInfo, IProgress iProgress, ILaunchNotification iLaunchNotification, ILauncher iLauncher) throws IOException {
        String[] stringArray = this.getLaunchCommandForLauncher(string, aIRLaunchInfo, false);
        Process process = this.m_debuggerCallbacks.launchDebugTarget(stringArray, iLauncher);
        this.startProcessListener(aIRLaunchInfo, false, iLaunchNotification, stringArray, process, true);
        return process;
    }

    private String[] getLaunchCommandForLauncher(String string, AIRLaunchInfo aIRLaunchInfo, boolean bl) throws IOException, FileNotFoundException {
        String[] stringArray;
        if (aIRLaunchInfo == null) {
            LaunchInfo launchInfo = new LaunchInfo(string);
            string = this.tweakNativeLaunchUri(string, bl, launchInfo);
            stringArray = new String[]{string};
        } else {
            stringArray = this.getAIRLaunchArgs(string, aIRLaunchInfo);
        }
        return stringArray;
    }

    @Override
    public Session launch(String string, AIRLaunchInfo aIRLaunchInfo, boolean bl, IProgress iProgress, ILaunchNotification iLaunchNotification, ILauncher iLauncher) throws IOException {
        String[] stringArray = this.getLaunchCommandForLauncher(string, aIRLaunchInfo, bl);
        Process process = this.m_debuggerCallbacks.launchDebugTarget(stringArray, iLauncher);
        ProcessListener processListener = this.startProcessListener(aIRLaunchInfo, bl, iLaunchNotification, stringArray, process, false);
        PlayerSession playerSession = null;
        if (bl) {
            playerSession = this.waitForConnection(string, aIRLaunchInfo, iProgress, process, processListener);
            playerSession.setLauncher(iLauncher);
        }
        return playerSession;
    }

    static {
        m_localizationManager.addLocalizer(new DebuggerLocalizer("flash.tools.debugger.concrete.djapi."));
    }

    private static enum OS {
        Mac,
        Windows,
        Unix;

    }

    private class LaunchInfo {
        private String m_uri;

        public LaunchInfo(String string) {
            this.m_uri = string;
        }

        public boolean isAbout() {
            return this.m_uri.startsWith("about:");
        }

        public boolean isHttpOrAbout() {
            return this.m_uri.startsWith("http:") || this.m_uri.startsWith("https:") || this.isAbout();
        }

        public boolean isWebPage() {
            return this.isHttpOrAbout() || this.m_uri.endsWith(".htm") || this.m_uri.endsWith(".html");
        }

        public boolean isWebBrowserNativeLaunch() {
            return this.isWebPage() && PlayerSessionManager.this.m_debuggerCallbacks.getHttpExe() != null;
        }

        public boolean isPlayerNativeLaunch() {
            return this.m_uri.length() > 0 && !this.isWebPage() && PlayerSessionManager.this.m_debuggerCallbacks.getPlayerExe() != null;
        }

        public boolean isAIRLaunch() {
            return this.m_uri.startsWith("file:") && (this.m_uri.endsWith("-app.xml") || this.m_uri.endsWith("application.xml"));
        }
    }
}

