/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public final class TableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Column> columns;
    private final PrimaryKey primaryKey;

    private TableSchema(List<Column> columns, PrimaryKey primaryKey) {
        this.columns = columns;
        this.primaryKey = primaryKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public static final class PrimaryKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String constraintName;
        private final List<String> columnNames;

        private PrimaryKey(String constraintName, List<String> columnNames) {
            this.constraintName = constraintName;
            this.columnNames = columnNames;
        }

        public static PrimaryKey of(String constraintName, List<String> columnNames) {
            return new PrimaryKey(constraintName, columnNames);
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public String toString() {
            return String.format("CONSTRAINT %s PRIMARY KEY (%s) NOT ENFORCED", this.constraintName, String.join((CharSequence)", ", this.columnNames));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimaryKey that = (PrimaryKey)o;
            return this.constraintName.equals(that.constraintName) && this.columnNames.equals(that.columnNames);
        }

        public int hashCode() {
            return Objects.hash(this.constraintName, this.columnNames);
        }
    }

    public static final class Builder {
        private final List<Column> columns = new ArrayList<Column>();
        private PrimaryKey primaryKey;

        public Builder columns(List<Column> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder column(Column column) {
            this.columns.add(column);
            return this;
        }

        public Builder physicalColumn(String name, SeaTunnelDataType<?> dataType) {
            this.columns.add(Column.physical(name, dataType));
            return this;
        }

        public Builder primaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder primaryKey(String constraintName, List<String> columnNames) {
            this.primaryKey = PrimaryKey.of(constraintName, columnNames);
            return this;
        }

        public TableSchema build() {
            return new TableSchema(this.columns, this.primaryKey);
        }
    }
}

