/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seatunnel.common.config.DeployMode;

public class Common {
    public static final int COLLECTION_SIZE = 16;
    private static final int PLUGIN_LIB_DIR_DEPTH = 3;
    private static DeployMode MODE;
    private static boolean STARTER;

    private Common() {
        throw new IllegalStateException("Utility class");
    }

    public static void setDeployMode(DeployMode mode) {
        MODE = mode;
    }

    public static void setStarter(boolean inStarter) {
        STARTER = inStarter;
    }

    public static DeployMode getDeployMode() {
        return MODE;
    }

    public static Path appRootDir() {
        if (DeployMode.CLIENT == MODE || STARTER) {
            try {
                String path = Common.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                path = new File(path).getPath();
                return Paths.get(path, new String[0]).getParent().getParent();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (DeployMode.CLUSTER == MODE) {
            return Paths.get("", new String[0]);
        }
        throw new IllegalStateException("deploy mode not support : " + (Object)((Object)MODE));
    }

    public static Path appLibDir() {
        return Common.appRootDir().resolve("lib");
    }

    public static Path pluginRootDir() {
        return Paths.get(Common.appRootDir().toString(), "plugins");
    }

    public static Path connectorRootDir(String engine) {
        return Paths.get(Common.appRootDir().toString(), "connectors", engine.toLowerCase());
    }

    public static Path connectorJarDir(String engine) {
        return Paths.get(Common.appRootDir().toString(), "connectors", engine.toLowerCase());
    }

    public static Path connectorDir() {
        return Paths.get(Common.appRootDir().toString(), "connectors");
    }

    public static Path pluginTarball() {
        return Common.appRootDir().resolve("plugins.tar.gz");
    }

    public static Path pluginDir(String pluginName) {
        return Paths.get(Common.pluginRootDir().toString(), pluginName);
    }

    public static Path pluginFilesDir(String pluginName) {
        return Paths.get(Common.pluginDir(pluginName).toString(), "files");
    }

    public static Path pluginLibDir(String pluginName) {
        return Paths.get(Common.pluginDir(pluginName).toString(), "lib");
    }

    public static List<Path> getPluginsJarDependencies() {
        List<Path> list;
        block9: {
            Path pluginRootDir = Common.pluginRootDir();
            if (!Files.exists(pluginRootDir, new LinkOption[0]) || !Files.isDirectory(pluginRootDir, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.walk(pluginRootDir, 3, FileVisitOption.FOLLOW_LINKS);
            try {
                list = stream.filter(it -> pluginRootDir.relativize((Path)it).getNameCount() == 3).filter(it -> it.getParent().endsWith("lib")).filter(it -> it.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    static {
        STARTER = false;
    }
}

