/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.config;

import java.util.List;
import org.apache.seatunnel.apis.base.env.RuntimeEnv;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.core.starter.config.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public abstract class EnvironmentFactory<ENVIRONMENT extends RuntimeEnv> {
    private static final String PLUGIN_NAME_KEY = "plugin_name";
    private final Config config;

    public EnvironmentFactory(Config config) {
        this.config = config;
    }

    public synchronized ENVIRONMENT getEnvironment() {
        Config envConfig = this.config.getConfig("env");
        ENVIRONMENT env = this.newEnvironment();
        env.setConfig(envConfig).setJobMode(this.getJobMode(envConfig)).prepare();
        return env;
    }

    protected abstract ENVIRONMENT newEnvironment();

    protected boolean checkIsContainHive() {
        List<? extends Config> sourceConfigList = this.config.getConfigList(PluginType.SOURCE.getType());
        for (Config config : sourceConfigList) {
            if (!config.getString(PLUGIN_NAME_KEY).toLowerCase().contains("hive")) continue;
            return true;
        }
        List<? extends Config> sinkConfigList = this.config.getConfigList(PluginType.SINK.getType());
        for (Config config : sinkConfigList) {
            if (!config.getString(PLUGIN_NAME_KEY).toLowerCase().contains("hive")) continue;
            return true;
        }
        return false;
    }

    private JobMode getJobMode(Config envConfig) {
        List<? extends Config> sourceConfigList;
        JobMode jobMode = envConfig.hasPath("job.mode") ? envConfig.getEnum(JobMode.class, "job.mode") : ((sourceConfigList = this.config.getConfigList(PluginType.SOURCE.getType())).get(0).getString(PLUGIN_NAME_KEY).toLowerCase().endsWith("stream") ? JobMode.STREAMING : JobMode.BATCH);
        return jobMode;
    }
}

