/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.table;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.transform.common.AbstractMultiCatalogMapTransform;
import org.apache.seatunnel.transform.table.TableFilterConfig;
import org.apache.seatunnel.transform.table.TableFilterTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFilterMultiCatalogTransform
extends AbstractMultiCatalogMapTransform {
    private static final Logger log = LoggerFactory.getLogger(TableFilterMultiCatalogTransform.class);

    public TableFilterMultiCatalogTransform(List<CatalogTable> inputCatalogTables, ReadonlyConfig config) {
        super(inputCatalogTables, config);
    }

    public String getPluginName() {
        return "TableFilter";
    }

    @Override
    protected SeaTunnelTransform<SeaTunnelRow> buildTransform(CatalogTable table, ReadonlyConfig config) {
        TableFilterConfig tableFilterConfig = TableFilterConfig.of(config);
        boolean include = tableFilterConfig.getDatabasePattern() == null && tableFilterConfig.getSchemaPattern() == null && tableFilterConfig.getTablePattern() == null ? TableFilterConfig.PatternMode.INCLUDE.equals((Object)tableFilterConfig.getPatternMode()) : tableFilterConfig.isMatch(table.getTablePath());
        return new TableFilterTransform(include, table);
    }

    @Override
    public List<CatalogTable> getProducedCatalogTables() {
        ArrayList<CatalogTable> outputTables = new ArrayList<CatalogTable>();
        for (CatalogTable catalogTable : this.inputCatalogTables) {
            String tableId = catalogTable.getTableId().toTablePath().toString();
            SeaTunnelTransform tableTransform = (SeaTunnelTransform)this.transformMap.get(tableId);
            if (!(tableTransform instanceof TableFilterTransform)) continue;
            TableFilterTransform tableFilterTransform = (TableFilterTransform)tableTransform;
            if (tableFilterTransform.isInclude()) {
                outputTables.add(catalogTable);
                continue;
            }
            log.info("Table {} is filtered out", (Object)tableId);
        }
        log.info("Input tables: {}", this.inputCatalogTables.stream().map((? super T e) -> e.getTablePath().getFullName()).collect(Collectors.toList()));
        log.info("Output tables: {}", outputTables.stream().map((? super T e) -> e.getTablePath().getFullName()).collect(Collectors.toList()));
        this.outputCatalogTables = outputTables;
        return outputTables;
    }
}

