/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientNotAllowedInClusterException;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.ClusterDiscoveryService;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.Addresses;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnection;
import com.hazelcast.client.impl.connection.tcp.WaitStrategy;
import com.hazelcast.client.impl.management.ManagementCenterService;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.nio.NioNetworking;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.internal.util.ThreadAffinity;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.executor.LoggingScheduledExecutor;
import com.hazelcast.internal.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.security.TokenCredentials;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.sql.impl.QueryUtils;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TcpClientConnectionManager
implements ClientConnectionManager {
    private static final int DEFAULT_SMART_CLIENT_THREAD_COUNT = 3;
    private static final int EXECUTOR_CORE_POOL_SIZE = 10;
    private static final int SMALL_MACHINE_PROCESSOR_COUNT = 8;
    private static final EndpointQualifier CLIENT_PUBLIC_ENDPOINT_QUALIFIER = EndpointQualifier.resolve(ProtocolType.CLIENT, "public");
    private static final int SQL_CONNECTION_RANDOM_ATTEMPTS = 10;
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    private final AtomicBoolean isAlive = new AtomicBoolean();
    private final ILogger logger;
    private final int connectionTimeoutMillis;
    private final HazelcastClientInstanceImpl client;
    private final Collection<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final NioNetworking networking;
    private final long authenticationTimeout;
    private final String connectionType;
    private final UUID clientUuid = UuidUtil.newUnsecureUUID();
    private final LinkedList<Integer> outboundPorts = new LinkedList();
    private final Set<String> labels;
    private final int outboundPortCount;
    private final boolean failoverConfigProvided;
    private final ScheduledExecutorService executor;
    private final boolean shuffleMemberList;
    private final WaitStrategy waitStrategy;
    private final ClusterDiscoveryService clusterDiscoveryService;
    private final boolean asyncStart;
    private final ClientConnectionStrategyConfig.ReconnectMode reconnectMode;
    private final LoadBalancer loadBalancer;
    private final boolean isSmartRoutingEnabled;
    private volatile Credentials currentCredentials;
    private final Object clientStateMutex = new Object();
    private final ConcurrentMap<UUID, TcpClientConnection> activeConnections = new ConcurrentHashMap<UUID, TcpClientConnection>();
    private volatile UUID clusterId;
    private volatile ClientState clientState = ClientState.INITIAL;
    private volatile boolean connectToClusterTaskSubmitted;

    public TcpClientConnectionManager(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.loadBalancer = client.getLoadBalancer();
        this.labels = Collections.unmodifiableSet(client.getClientConfig().getLabels());
        this.logger = client.getLoggingService().getLogger(ClientConnectionManager.class);
        this.connectionType = client.getProperties().getBoolean(ManagementCenterService.MC_CLIENT_MODE_PROP) ? "MCJVM" : "JVM";
        this.connectionTimeoutMillis = this.initConnectionTimeoutMillis();
        this.networking = this.initNetworking();
        this.outboundPorts.addAll(this.getOutboundPorts());
        this.outboundPortCount = this.outboundPorts.size();
        this.authenticationTimeout = client.getProperties().getPositiveMillisOrDefault(ClientProperty.HEARTBEAT_TIMEOUT);
        this.failoverConfigProvided = client.getFailoverConfig() != null;
        this.executor = this.createExecutorService();
        this.clusterDiscoveryService = client.getClusterDiscoveryService();
        this.waitStrategy = this.initializeWaitStrategy(client.getClientConfig());
        this.shuffleMemberList = client.getProperties().getBoolean(ClientProperty.SHUFFLE_MEMBER_LIST);
        this.isSmartRoutingEnabled = client.getClientConfig().getNetworkConfig().isSmartRouting();
        this.asyncStart = client.getClientConfig().getConnectionStrategyConfig().isAsyncStart();
        this.reconnectMode = client.getClientConfig().getConnectionStrategyConfig().getReconnectMode();
    }

    private int initConnectionTimeoutMillis() {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        return connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
    }

    private ScheduledExecutorService createExecutorService() {
        ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
        String name = this.client.getName();
        return new LoggingScheduledExecutor(this.logger, 10, new PoolExecutorThreadFactory(name + ".internal-", classLoader), (r, executor) -> {
            String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
            this.logger.finest(message);
            throw new RejectedExecutionException(message);
        });
    }

    private Collection<Integer> getOutboundPorts() {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        Collection<Integer> outboundPorts = networkConfig.getOutboundPorts();
        Collection<String> outboundPortDefinitions = networkConfig.getOutboundPortDefinitions();
        return AddressUtil.getOutboundPorts(outboundPorts, outboundPortDefinitions);
    }

    public NioNetworking getNetworking() {
        return this.networking;
    }

    protected NioNetworking initNetworking() {
        HazelcastProperties properties = this.client.getProperties();
        int configuredInputThreads = properties.getInteger(ClientProperty.IO_INPUT_THREAD_COUNT);
        int configuredOutputThreads = properties.getInteger(ClientProperty.IO_OUTPUT_THREAD_COUNT);
        int inputThreads = configuredInputThreads == -1 ? (this.isSmartRoutingEnabled && RuntimeAvailableProcessors.get() > 8 ? 3 : 1) : configuredInputThreads;
        int outputThreads = configuredOutputThreads == -1 ? (this.isSmartRoutingEnabled && RuntimeAvailableProcessors.get() > 8 ? 3 : 1) : configuredOutputThreads;
        return new NioNetworking(new NioNetworking.Context().loggingService(this.client.getLoggingService()).metricsRegistry(this.client.getMetricsRegistry()).threadNamePrefix(this.client.getName()).errorHandler(new ClientConnectionChannelErrorHandler()).inputThreadCount(inputThreads).inputThreadAffinity(ThreadAffinity.newSystemThreadAffinity("hazelcast.client.io.input.thread.affinity")).outputThreadCount(outputThreads).outputThreadAffinity(ThreadAffinity.newSystemThreadAffinity("hazelcast.client.io.output.thread.affinity")).balancerIntervalSeconds(properties.getInteger(ClientProperty.IO_BALANCER_INTERVAL_SECONDS)).writeThroughEnabled(properties.getBoolean(ClientProperty.IO_WRITE_THROUGH_ENABLED)).concurrencyDetection(this.client.getConcurrencyDetection()));
    }

    private WaitStrategy initializeWaitStrategy(ClientConfig clientConfig) {
        ConnectionRetryConfig retryConfig = clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig();
        long clusterConnectTimeout = retryConfig.getClusterConnectTimeoutMillis();
        if (clusterConnectTimeout == -1L) {
            clusterConnectTimeout = this.failoverConfigProvided ? 120000L : Long.MAX_VALUE;
        }
        return new WaitStrategy(retryConfig.getInitialBackoffMillis(), retryConfig.getMaxBackoffMillis(), retryConfig.getMultiplier(), clusterConnectTimeout, retryConfig.getJitter(), this.logger);
    }

    public synchronized void start() {
        if (!this.isAlive.compareAndSet(false, true)) {
            return;
        }
        this.startNetworking();
    }

    public void tryConnectToAllClusterMembers(boolean sync) {
        if (!this.isSmartRoutingEnabled) {
            return;
        }
        if (sync) {
            for (Member member : this.client.getClientClusterService().getMemberList()) {
                try {
                    this.getOrConnectToMember(member, false);
                }
                catch (Exception e) {
                    EmptyStatement.ignore(e);
                }
            }
        }
        this.executor.scheduleWithFixedDelay(new ConnectToAllClusterMembersTask(), 1L, 1L, TimeUnit.SECONDS);
    }

    protected void startNetworking() {
        this.networking.restart();
    }

    public synchronized void shutdown() {
        if (!this.isAlive.compareAndSet(true, false)) {
            return;
        }
        this.executor.shutdownNow();
        ClientExecutionServiceImpl.awaitExecutorTermination("cluster", this.executor, this.logger);
        for (Connection connection : this.activeConnections.values()) {
            connection.close("Hazelcast client is shutting down", null);
        }
        this.stopNetworking();
        this.connectionListeners.clear();
        this.clusterDiscoveryService.current().destroy();
    }

    protected void stopNetworking() {
        this.networking.shutdown();
    }

    public void connectToCluster() {
        this.clusterDiscoveryService.current().start();
        if (this.asyncStart) {
            this.submitConnectToClusterTask();
        } else {
            this.doConnectToCluster();
        }
    }

    private void submitConnectToClusterTask() {
        if (this.connectToClusterTaskSubmitted) {
            return;
        }
        this.executor.submit(() -> {
            try {
                this.doConnectToCluster();
                Object object = this.clientStateMutex;
                synchronized (object) {
                    this.connectToClusterTaskSubmitted = false;
                    if (this.activeConnections.isEmpty()) {
                        if (this.logger.isFineEnabled()) {
                            this.logger.warning("No connection to cluster: " + this.clusterId);
                        }
                        this.submitConnectToClusterTask();
                    }
                }
            }
            catch (Throwable e) {
                this.logger.warning("Could not connect to any cluster, shutting down the client: " + e.getMessage());
                this.shutdownWithExternalThread();
            }
        });
        this.connectToClusterTaskSubmitted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectToCluster() {
        CandidateClusterContext currentContext = this.clusterDiscoveryService.current();
        this.logger.info("Trying to connect to cluster: " + currentContext.getClusterName());
        if (this.doConnectToCandidateCluster(currentContext, false)) {
            return;
        }
        Object object = this.clientStateMutex;
        synchronized (object) {
            if (!this.activeConnections.isEmpty()) {
                return;
            }
            this.clientState = ClientState.SWITCHING_CLUSTER;
        }
        if (this.clusterDiscoveryService.tryNextCluster(this::destroyCurrentClusterConnectionAndTryNextCluster)) {
            return;
        }
        String msg = this.client.getLifecycleService().isRunning() ? "Unable to connect to any cluster." : "Client is being shutdown.";
        throw new IllegalStateException(msg);
    }

    private Boolean destroyCurrentClusterConnectionAndTryNextCluster(CandidateClusterContext currentContext, CandidateClusterContext nextContext) {
        currentContext.destroy();
        this.client.onClusterChange();
        nextContext.start();
        ((ClientLoggingService)this.client.getLoggingService()).updateClusterName(nextContext.getClusterName());
        this.logger.info("Trying to connect to next cluster: " + nextContext.getClusterName());
        if (this.doConnectToCandidateCluster(nextContext, true)) {
            this.client.waitForInitialMembershipEvents();
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CHANGED_CLUSTER);
            return true;
        }
        return false;
    }

    Connection connect(Object target, Function<Object, Connection> getOrConnectFunction) {
        try {
            this.logger.info("Trying to connect to " + target);
            return getOrConnectFunction.apply(target);
        }
        catch (InvalidConfigurationException e) {
            this.logger.warning("Exception during initial connection to " + target + ": " + e);
            throw ExceptionUtil.rethrow(e);
        }
        catch (ClientNotAllowedInClusterException e) {
            this.logger.warning("Exception during initial connection to " + target + ": " + e);
            throw e;
        }
        catch (Exception e) {
            this.logger.warning("Exception during initial connection to " + target + ": " + e);
            return null;
        }
    }

    private void fireLifecycleEvent(LifecycleEvent.LifecycleState state) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        lifecycleService.fireLifecycleEvent(state);
    }

    private boolean doConnectToCandidateCluster(CandidateClusterContext context, boolean switchingToNextCluster) {
        HashSet triedAddresses = new HashSet();
        try {
            this.waitStrategy.reset();
            do {
                Connection connection;
                HashSet<Address> triedAddressesPerAttempt = new HashSet<Address>();
                ArrayList<Member> memberList = new ArrayList<Member>(this.client.getClientClusterService().getMemberList());
                if (this.shuffleMemberList) {
                    Collections.shuffle(memberList);
                }
                for (Member member : memberList) {
                    this.checkClientActive();
                    triedAddressesPerAttempt.add(member.getAddress());
                    connection = this.connect(member, o -> this.getOrConnectToMember((Member)o, switchingToNextCluster));
                    if (connection == null) continue;
                    return true;
                }
                for (Address address : this.getPossibleMemberAddresses(context.getAddressProvider())) {
                    this.checkClientActive();
                    if (!triedAddressesPerAttempt.add(address) || (connection = this.connect(address, o -> this.getOrConnectToAddress((Address)o, switchingToNextCluster))) == null) continue;
                    return true;
                }
                triedAddresses.addAll(triedAddressesPerAttempt);
                if (!triedAddressesPerAttempt.isEmpty()) continue;
                this.checkClientActive();
            } while (this.waitStrategy.sleep());
        }
        catch (ClientNotAllowedInClusterException | InvalidConfigurationException e) {
            this.logger.warning("Stopped trying on the cluster: " + context.getClusterName() + " reason: " + e.getMessage());
        }
        this.logger.info("Unable to connect to any address from the cluster with name: " + context.getClusterName() + ". The following addresses were tried: " + triedAddresses);
        return false;
    }

    @Override
    public String getConnectionType() {
        return this.connectionType;
    }

    @Override
    public void checkInvocationAllowed() throws IOException {
        ClientState state = this.clientState;
        if (state == ClientState.INITIALIZED_ON_CLUSTER && this.activeConnections.size() > 0) {
            return;
        }
        if (state == ClientState.INITIAL) {
            if (this.asyncStart) {
                throw new HazelcastClientOfflineException();
            }
            throw new IOException("No connection found to cluster since the client is starting.");
        }
        if (ClientConnectionStrategyConfig.ReconnectMode.ASYNC.equals((Object)this.reconnectMode)) {
            throw new HazelcastClientOfflineException();
        }
        throw new IOException("No connection found to cluster.");
    }

    Collection<Address> getPossibleMemberAddresses(AddressProvider addressProvider) {
        LinkedHashSet<Address> addresses = new LinkedHashSet<Address>();
        try {
            Addresses result2 = addressProvider.loadAddresses();
            if (this.shuffleMemberList) {
                Collections.shuffle(result2.primary());
                Collections.shuffle(result2.secondary());
            }
            addresses.addAll(result2.primary());
            addresses.addAll(result2.secondary());
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warning("Exception from AddressProvider: " + addressProvider, e);
        }
        return addresses;
    }

    private void shutdownWithExternalThread() {
        new Thread(() -> {
            try {
                this.client.getLifecycleService().shutdown();
            }
            catch (Exception exception) {
                this.logger.severe("Exception during client shutdown", exception);
            }
        }, this.client.getName() + ".clientShutdown-").start();
    }

    @Override
    public Collection<Connection> getActiveConnections() {
        return this.activeConnections.values();
    }

    @Override
    public boolean isAlive() {
        return this.isAlive.get();
    }

    @Override
    public UUID getClientUuid() {
        return this.clientUuid;
    }

    @Override
    public ClientConnection getConnection(@Nonnull UUID uuid) {
        return (ClientConnection)this.activeConnections.get(uuid);
    }

    TcpClientConnection getOrConnectToAddress(@Nonnull Address address, boolean switchingToNextCluster) {
        for (TcpClientConnection connection : this.activeConnections.values()) {
            if (!connection.getRemoteAddress().equals(address)) continue;
            return connection;
        }
        address = this.translate(address);
        TcpClientConnection connection = this.createSocketConnection(address);
        ClientAuthenticationCodec.ResponseParameters response = this.authenticateOnCluster(connection);
        return this.onAuthenticated(connection, response, switchingToNextCluster);
    }

    TcpClientConnection getOrConnectToMember(@Nonnull Member member, boolean switchingToNextCluster) {
        UUID uuid = member.getUuid();
        TcpClientConnection connection = (TcpClientConnection)this.activeConnections.get(uuid);
        if (connection != null) {
            return connection;
        }
        Address address = this.translate(member);
        connection = this.createSocketConnection(address);
        ClientAuthenticationCodec.ResponseParameters response = this.authenticateOnCluster(connection);
        return this.onAuthenticated(connection, response, switchingToNextCluster);
    }

    private void fireConnectionEvent(TcpClientConnection connection, boolean isAdded) {
        if (!this.isAlive()) {
            return;
        }
        try {
            this.executor.execute(() -> {
                for (ConnectionListener listener : this.connectionListeners) {
                    if (isAdded) {
                        listener.connectionAdded(connection);
                        continue;
                    }
                    listener.connectionRemoved(connection);
                }
            });
        }
        catch (RejectedExecutionException e) {
            EmptyStatement.ignore(e);
        }
    }

    private boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireOutboundPort() {
        if (this.outboundPortCount == 0) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    private void bindSocketToPort(Socket socket) throws IOException {
        if (this.useAnyOutboundPort()) {
            InetSocketAddress socketAddress = new InetSocketAddress(0);
            socket.bind(socketAddress);
        } else {
            int retryCount = this.outboundPortCount * 2;
            IOException ex = null;
            for (int i = 0; i < retryCount; ++i) {
                int port = this.acquireOutboundPort();
                if (port == 0) {
                    return;
                }
                InetSocketAddress socketAddress = new InetSocketAddress(port);
                try {
                    socket.bind(socketAddress);
                    return;
                }
                catch (IOException e) {
                    ex = e;
                    this.logger.finest("Could not bind port[ " + port + "]: " + e.getMessage());
                    continue;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    protected TcpClientConnection createSocketConnection(Address target) {
        CandidateClusterContext currentClusterContext = this.clusterDiscoveryService.current();
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            this.bindSocketToPort(socket);
            Channel channel = this.networking.register(currentClusterContext.getChannelInitializer(), socketChannel, true);
            channel.attributeMap().put(Address.class, target);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(target.getInetAddress(), target.getPort());
            channel.connect(inetSocketAddress, this.connectionTimeoutMillis);
            TcpClientConnection connection = new TcpClientConnection(this.client, this.connectionIdGen.incrementAndGet(), channel);
            socketChannel.configureBlocking(true);
            SocketInterceptor socketInterceptor = currentClusterContext.getSocketInterceptor();
            if (socketInterceptor != null) {
                socketInterceptor.onConnect(socket);
            }
            channel.start();
            return connection;
        }
        catch (Exception e) {
            IOUtil.closeResource(socketChannel);
            this.logger.finest(e);
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Address translate(Member member) {
        if (this.client.getClientClusterService().translateToPublicAddress()) {
            Address publicAddress = member.getAddressMap().get(CLIENT_PUBLIC_ENDPOINT_QUALIFIER);
            if (publicAddress != null) {
                return publicAddress;
            }
            return member.getAddress();
        }
        return this.translate(member.getAddress());
    }

    private Address translate(Address target) {
        CandidateClusterContext currentContext = this.clusterDiscoveryService.current();
        AddressProvider addressProvider = currentContext.getAddressProvider();
        try {
            Address translatedAddress = addressProvider.translate(target);
            if (translatedAddress == null) {
                throw new HazelcastException("Address Provider " + addressProvider.getClass() + " could not translate address " + target);
            }
            return translatedAddress;
        }
        catch (Exception e) {
            this.logger.warning("Failed to translate address " + target + " via address provider " + e.getMessage());
            throw ExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnectionClose(TcpClientConnection connection) {
        this.client.getInvocationService().onConnectionClose(connection);
        Address endpoint = connection.getRemoteAddress();
        UUID memberUuid = connection.getRemoteUuid();
        if (endpoint == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Destroying " + connection + ", but it has end-point set to null -> not removing it from a connection map");
            }
            return;
        }
        Object object = this.clientStateMutex;
        synchronized (object) {
            if (this.activeConnections.remove(memberUuid, connection)) {
                this.logger.info("Removed connection to endpoint: " + endpoint + ":" + memberUuid + ", connection: " + connection);
                if (this.activeConnections.isEmpty()) {
                    if (this.clientState == ClientState.INITIALIZED_ON_CLUSTER) {
                        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
                    }
                    this.triggerClusterReconnection();
                }
                this.fireConnectionEvent(connection, false);
            } else if (this.logger.isFinestEnabled()) {
                this.logger.finest("Destroying a connection, but there is no mapping " + endpoint + ":" + memberUuid + " -> " + connection + " in the connection map.");
            }
        }
    }

    private void triggerClusterReconnection() {
        if (this.reconnectMode == ClientConnectionStrategyConfig.ReconnectMode.OFF) {
            this.logger.info("RECONNECT MODE is off. Shutting down the client.");
            this.shutdownWithExternalThread();
            return;
        }
        if (this.client.getLifecycleService().isRunning()) {
            try {
                this.submitConnectToClusterTask();
            }
            catch (RejectedExecutionException r) {
                this.shutdownWithExternalThread();
            }
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public Credentials getCurrentCredentials() {
        return this.currentCredentials;
    }

    public void reset() {
        for (TcpClientConnection activeConnection : this.activeConnections.values()) {
            activeConnection.close(null, new TargetDisconnectedException("Closing since client is switching cluster"));
        }
    }

    @Override
    public ClientConnection getRandomConnection() {
        Iterator iterator2;
        if (this.isSmartRoutingEnabled) {
            ClientConnection connection;
            Member member = this.loadBalancer.next();
            ClientConnection clientConnection = connection = member != null ? (ClientConnection)this.activeConnections.get(member.getUuid()) : null;
            if (connection != null) {
                return connection;
            }
        }
        if ((iterator2 = this.activeConnections.entrySet().iterator()).hasNext()) {
            Map.Entry connectionEntry = iterator2.next();
            return (ClientConnection)connectionEntry.getValue();
        }
        return null;
    }

    @Override
    public ClientConnection getConnectionForSql() {
        if (this.isSmartRoutingEnabled) {
            Member member;
            for (int i = 0; i < 10 && (member = QueryUtils.memberOfLargerSameVersionGroup(this.client.getClientClusterService().getMemberList(), null)) != null; ++i) {
                ClientConnection connection = (ClientConnection)this.activeConnections.get(member.getUuid());
                if (connection == null) continue;
                return connection;
            }
        }
        ClientConnection firstConnection = null;
        for (Map.Entry connectionEntry : this.activeConnections.entrySet()) {
            if (firstConnection == null) {
                firstConnection = (ClientConnection)connectionEntry.getValue();
            }
            UUID memberId = (UUID)connectionEntry.getKey();
            Member member = this.client.getClientClusterService().getMember(memberId);
            if (member == null || member.isLiteMember()) continue;
            return (ClientConnection)connectionEntry.getValue();
        }
        return firstConnection;
    }

    private ClientAuthenticationCodec.ResponseParameters authenticateOnCluster(TcpClientConnection connection) {
        Address memberAddress = connection.getInitAddress();
        ClientMessage request = this.encodeAuthenticationRequest(memberAddress);
        ClientInvocationFuture future = new ClientInvocation(this.client, request, null, connection).invokeUrgent();
        try {
            return ClientAuthenticationCodec.decodeResponse((ClientMessage)future.get(this.authenticationTimeout, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            connection.close("Failed to authenticate connection", e);
            throw ExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpClientConnection onAuthenticated(TcpClientConnection connection, ClientAuthenticationCodec.ResponseParameters response, boolean switchingToNextCluster) {
        Object object = this.clientStateMutex;
        synchronized (object) {
            boolean clusterIdChanged;
            this.checkAuthenticationResponse(connection, response);
            connection.setConnectedServerVersion(response.serverHazelcastVersion);
            connection.setRemoteAddress(response.address);
            connection.setRemoteUuid(response.memberUuid);
            TcpClientConnection existingConnection = (TcpClientConnection)this.activeConnections.get(response.memberUuid);
            if (existingConnection != null) {
                connection.close("Duplicate connection to same member with uuid : " + response.memberUuid, null);
                return existingConnection;
            }
            UUID newClusterId = response.clusterId;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Checking the cluster: " + newClusterId + ", current cluster: " + this.clusterId);
            }
            boolean bl = clusterIdChanged = this.clusterId != null && !newClusterId.equals(this.clusterId);
            if (clusterIdChanged) {
                this.checkClientStateOnClusterIdChange(connection, switchingToNextCluster);
                this.logger.warning("Switching from current cluster: " + this.clusterId + " to new cluster: " + newClusterId);
                this.client.onClusterRestart();
            }
            this.checkClientState(connection, switchingToNextCluster);
            boolean connectionsEmpty = this.activeConnections.isEmpty();
            this.activeConnections.put(response.memberUuid, connection);
            if (connectionsEmpty) {
                this.clusterId = newClusterId;
                if (clusterIdChanged) {
                    this.clientState = ClientState.CONNECTED_TO_CLUSTER;
                    this.executor.execute(() -> this.initializeClientOnCluster(newClusterId));
                } else {
                    this.clientState = ClientState.INITIALIZED_ON_CLUSTER;
                    this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
                }
            }
            this.logger.info("Authenticated with server " + response.address + ":" + response.memberUuid + ", server version: " + response.serverHazelcastVersion + ", local address: " + connection.getLocalSocketAddress());
            this.fireConnectionEvent(connection, true);
        }
        if (!connection.isAlive()) {
            this.onConnectionClose(connection);
        }
        return connection;
    }

    private void checkClientState(TcpClientConnection connection, boolean switchingToNextCluster) {
        if (this.clientState == ClientState.SWITCHING_CLUSTER && !switchingToNextCluster) {
            String reason = "There is a cluster switch in progress. This connection attempt initiated before the progress and not allowed to be authenticated.";
            connection.close(reason, null);
            throw new AuthenticationException(reason);
        }
        if (this.clientState != ClientState.SWITCHING_CLUSTER && switchingToNextCluster) {
            String reason = "The cluster switch is already completed. This connection attempt is not allowed to be authenticated.";
            connection.close(reason, null);
            throw new AuthenticationException(reason);
        }
    }

    private void checkAuthenticationResponse(TcpClientConnection connection, ClientAuthenticationCodec.ResponseParameters response) {
        AuthenticationStatus authenticationStatus = AuthenticationStatus.getById(response.status);
        if (this.failoverConfigProvided && !response.failoverSupported) {
            this.logger.warning("Cluster does not support failover. This feature is available in Hazelcast Enterprise");
            authenticationStatus = AuthenticationStatus.NOT_ALLOWED_IN_CLUSTER;
        }
        switch (authenticationStatus) {
            case AUTHENTICATED: {
                break;
            }
            case CREDENTIALS_FAILED: {
                AuthenticationException authException = new AuthenticationException("Authentication failed. The configured cluster name on the client (see ClientConfig.setClusterName()) does not match the one configured in the cluster or the credentials set in the Client security config could not be authenticated");
                connection.close("Failed to authenticate connection", authException);
                throw authException;
            }
            case NOT_ALLOWED_IN_CLUSTER: {
                ClientNotAllowedInClusterException notAllowedException = new ClientNotAllowedInClusterException("Client is not allowed in the cluster");
                connection.close("Failed to authenticate connection", notAllowedException);
                throw notAllowedException;
            }
            default: {
                AuthenticationException exception = new AuthenticationException("Authentication status code not supported. status: " + (Object)((Object)authenticationStatus));
                connection.close("Failed to authenticate connection", exception);
                throw exception;
            }
        }
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        if (!partitionService.checkAndSetPartitionCount(response.partitionCount)) {
            ClientNotAllowedInClusterException exception = new ClientNotAllowedInClusterException("Client can not work with this cluster because it has a different partition count. Expected partition count: " + partitionService.getPartitionCount() + ", Member partition count: " + response.partitionCount);
            connection.close("Failed to authenticate connection", exception);
            throw exception;
        }
    }

    private void checkClientStateOnClusterIdChange(TcpClientConnection connection, boolean switchingToNextCluster) {
        if (this.activeConnections.isEmpty()) {
            if (this.failoverConfigProvided && !switchingToNextCluster) {
                String reason = "Force to hard cluster switch";
                connection.close(reason, null);
                throw new ClientNotAllowedInClusterException(reason);
            }
        } else {
            String reason = "Connection does not belong to this cluster";
            connection.close(reason, null);
            throw new IllegalStateException(reason);
        }
    }

    private ClientMessage encodeAuthenticationRequest(Address toAddress) {
        InternalSerializationService ss = this.client.getSerializationService();
        byte serializationVersion = ss.getVersion();
        CandidateClusterContext currentContext = this.clusterDiscoveryService.current();
        Credentials credentials = currentContext.getCredentialsFactory().newCredentials(toAddress);
        String clusterName = currentContext.getClusterName();
        this.currentCredentials = credentials;
        if (credentials instanceof PasswordCredentials) {
            PasswordCredentials cr = (PasswordCredentials)credentials;
            return ClientAuthenticationCodec.encodeRequest(clusterName, cr.getName(), cr.getPassword(), this.clientUuid, this.connectionType, serializationVersion, BuildInfoProvider.getBuildInfo().getVersion(), this.client.getName(), this.labels);
        }
        byte[] secretBytes = credentials instanceof TokenCredentials ? ((TokenCredentials)credentials).getToken() : ss.toData(credentials).toByteArray();
        return ClientAuthenticationCustomCodec.encodeRequest(clusterName, secretBytes, this.clientUuid, this.connectionType, serializationVersion, BuildInfoProvider.getBuildInfo().getVersion(), this.client.getName(), this.labels);
    }

    protected void checkClientActive() {
        if (!this.client.getLifecycleService().isRunning()) {
            throw new HazelcastClientNotActiveException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeClientOnCluster(UUID targetClusterId) {
        try {
            Object object = this.clientStateMutex;
            synchronized (object) {
                if (!targetClusterId.equals(this.clusterId)) {
                    this.logger.warning("Won't send client state to cluster: " + targetClusterId + " Because switched to a new cluster: " + this.clusterId);
                    return;
                }
            }
            this.client.sendStateToCluster();
            object = this.clientStateMutex;
            synchronized (object) {
                if (targetClusterId.equals(this.clusterId)) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine("Client state is sent to cluster: " + targetClusterId);
                    }
                    this.clientState = ClientState.INITIALIZED_ON_CLUSTER;
                    this.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
                } else if (this.logger.isFineEnabled()) {
                    this.logger.warning("Cannot set client state to " + (Object)((Object)ClientState.INITIALIZED_ON_CLUSTER) + " because current cluster id: " + this.clusterId + " is different than expected cluster id: " + targetClusterId);
                }
            }
        }
        catch (Exception e) {
            String clusterName = this.clusterDiscoveryService.current().getClusterName();
            this.logger.warning("Failure during sending state to the cluster.", e);
            Object object = this.clientStateMutex;
            synchronized (object) {
                if (targetClusterId.equals(this.clusterId)) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.warning("Retrying sending state to the cluster: " + targetClusterId + ", name: " + clusterName);
                    }
                    this.executor.execute(() -> this.initializeClientOnCluster(targetClusterId));
                }
            }
        }
    }

    private class ConnectToAllClusterMembersTask
    implements Runnable {
        private final Set<UUID> connectingAddresses = Collections.newSetFromMap(new ConcurrentHashMap());

        private ConnectToAllClusterMembersTask() {
        }

        @Override
        public void run() {
            if (!TcpClientConnectionManager.this.client.getLifecycleService().isRunning()) {
                return;
            }
            for (Member member : TcpClientConnectionManager.this.client.getClientClusterService().getMemberList()) {
                if (TcpClientConnectionManager.this.clientState == ClientState.SWITCHING_CLUSTER) {
                    return;
                }
                UUID uuid = member.getUuid();
                if (TcpClientConnectionManager.this.activeConnections.get(uuid) != null || !this.connectingAddresses.add(uuid)) continue;
                TcpClientConnectionManager.this.executor.submit(() -> {
                    try {
                        if (!TcpClientConnectionManager.this.client.getLifecycleService().isRunning()) {
                            return;
                        }
                        TcpClientConnectionManager.this.getOrConnectToMember(member, false);
                    }
                    catch (Exception e) {
                        if (TcpClientConnectionManager.this.logger.isFineEnabled()) {
                            TcpClientConnectionManager.this.logger.warning("Could not connect to member " + uuid, e);
                        } else {
                            TcpClientConnectionManager.this.logger.warning("Could not connect to member " + uuid + ", reason " + e);
                        }
                    }
                    finally {
                        this.connectingAddresses.remove(uuid);
                    }
                });
            }
        }
    }

    private class ClientConnectionChannelErrorHandler
    implements ChannelErrorHandler {
        private ClientConnectionChannelErrorHandler() {
        }

        @Override
        public void onError(Channel channel, Throwable cause) {
            if (channel == null) {
                TcpClientConnectionManager.this.logger.severe(cause);
            } else {
                if (cause instanceof OutOfMemoryError) {
                    TcpClientConnectionManager.this.logger.severe(cause);
                }
                Connection connection = (Connection)channel.attributeMap().get(TcpClientConnection.class);
                if (cause instanceof EOFException) {
                    connection.close("Connection closed by the other side", cause);
                } else {
                    connection.close("Exception in " + connection + ", thread=" + Thread.currentThread().getName(), cause);
                }
            }
        }
    }

    private static enum ClientState {
        INITIAL,
        CONNECTED_TO_CLUSTER,
        INITIALIZED_ON_CLUSTER,
        SWITCHING_CLUSTER;

    }
}

