/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MutableInteger;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.mapstore.writebehind.IPredicate;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CyclicWriteBehindQueue
implements WriteBehindQueue<DelayedEntry> {
    private final Deque<DelayedEntry> deque = new ArrayDeque<DelayedEntry>();
    private final Map<Data, MutableInteger> index = new HashMap<Data, MutableInteger>();

    CyclicWriteBehindQueue() {
    }

    @Override
    public void addFirst(Collection<DelayedEntry> collection) {
        for (DelayedEntry entry : collection) {
            this.deque.addFirst(entry);
        }
        this.addCountIndex(collection);
    }

    @Override
    public void addLast(DelayedEntry entry, boolean addWithoutCapacityCheck) {
        this.deque.addLast(entry);
        this.addCountIndex(entry);
    }

    @Override
    public DelayedEntry peek() {
        return this.deque.peek();
    }

    @Override
    public boolean removeFirstOccurrence(DelayedEntry entry) {
        DelayedEntry removedEntry = this.deque.pollFirst();
        if (removedEntry == null) {
            return false;
        }
        this.decreaseCountIndex(entry);
        return true;
    }

    @Override
    public boolean contains(DelayedEntry entry) {
        Data key = (Data)entry.getKey();
        return this.index.containsKey(key);
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public void clear() {
        this.deque.clear();
        this.resetCountIndex();
    }

    @Override
    public int drainTo(Collection<DelayedEntry> collection) {
        Preconditions.checkNotNull(collection, "collection can not be null");
        Iterator<DelayedEntry> iterator2 = this.deque.iterator();
        while (iterator2.hasNext()) {
            DelayedEntry e = iterator2.next();
            collection.add(e);
            iterator2.remove();
        }
        this.resetCountIndex();
        return collection.size();
    }

    @Override
    public List<DelayedEntry> asList() {
        return Collections.unmodifiableList(new ArrayList<DelayedEntry>(this.deque));
    }

    @Override
    public void filter(IPredicate<DelayedEntry> predicate, Collection<DelayedEntry> collection) {
        for (DelayedEntry e : this.deque) {
            if (!predicate.test(e)) break;
            collection.add(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.getClass().isAssignableFrom(clazz)) {
            return (T)this;
        }
        return null;
    }

    private void addCountIndex(DelayedEntry entry) {
        Map<Data, MutableInteger> index = this.index;
        Data key = (Data)entry.getKey();
        MutableInteger count2 = index.get(key);
        if (count2 == null) {
            count2 = new MutableInteger();
        }
        ++count2.value;
        index.put(key, count2);
    }

    private void addCountIndex(Collection<DelayedEntry> collection) {
        for (DelayedEntry entry : collection) {
            this.addCountIndex(entry);
        }
    }

    private void decreaseCountIndex(DelayedEntry entry) {
        Map<Data, MutableInteger> index = this.index;
        Data key = (Data)entry.getKey();
        MutableInteger count2 = index.get(key);
        if (count2 == null) {
            return;
        }
        --count2.value;
        if (count2.value == 0) {
            index.remove(key);
        } else {
            index.put(key, count2);
        }
    }

    private void resetCountIndex() {
        this.index.clear();
    }
}

