/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.format.json.debezium.DebeziumRowConverter;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class DebeziumJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s operation is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    public static final String FORMAT = "Debezium";
    private final SeaTunnelRowType rowType;
    private final JsonDeserializationSchema jsonDeserializer;
    private final DebeziumRowConverter debeziumRowConverter;
    private final boolean ignoreParseErrors;
    private final boolean debeziumEnabledSchema;
    private CatalogTable catalogTable;

    public DebeziumJsonDeserializationSchema(CatalogTable catalogTable, boolean ignoreParseErrors) {
        this.catalogTable = catalogTable;
        this.rowType = catalogTable.getSeaTunnelRowType();
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonDeserializationSchema(catalogTable, false, ignoreParseErrors);
        this.debeziumRowConverter = new DebeziumRowConverter(this.rowType);
        this.debeziumEnabledSchema = false;
    }

    public DebeziumJsonDeserializationSchema(CatalogTable catalogTable, boolean ignoreParseErrors, boolean debeziumEnabledSchema) {
        this.catalogTable = catalogTable;
        this.rowType = catalogTable.getSeaTunnelRowType();
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonDeserializationSchema(catalogTable, false, ignoreParseErrors);
        this.debeziumRowConverter = new DebeziumRowConverter(this.rowType);
        this.debeziumEnabledSchema = debeziumEnabledSchema;
        this.catalogTable = catalogTable;
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) {
        TablePath tablePath = Optional.ofNullable(this.catalogTable).map(CatalogTable::getTablePath).orElse(null);
        this.deserializeMessage(message, out, tablePath);
    }

    private void deserializeMessage(byte[] message, Collector<SeaTunnelRow> out, TablePath tablePath) {
        block20: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                String op;
                JsonNode payload = this.getPayload(this.convertBytes(message));
                switch (op = payload.get("op").asText()) {
                    case "c": 
                    case "r": {
                        SeaTunnelRow insert = this.convertJsonNode(payload.get("after"));
                        insert.setRowKind(RowKind.INSERT);
                        if (tablePath != null) {
                            insert.setTableId(tablePath.toString());
                        }
                        out.collect((Object)insert);
                        break;
                    }
                    case "u": {
                        SeaTunnelRow before = this.convertJsonNode(payload.get("before"));
                        if (before == null) {
                            throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                        }
                        before.setRowKind(RowKind.UPDATE_BEFORE);
                        if (tablePath != null) {
                            before.setTableId(tablePath.toString());
                        }
                        out.collect((Object)before);
                        SeaTunnelRow after = this.convertJsonNode(payload.get("after"));
                        after.setRowKind(RowKind.UPDATE_AFTER);
                        if (tablePath != null) {
                            after.setTableId(tablePath.toString());
                        }
                        out.collect((Object)after);
                        break;
                    }
                    case "d": {
                        SeaTunnelRow delete = this.convertJsonNode(payload.get("before"));
                        if (delete == null) {
                            throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                        }
                        delete.setRowKind(RowKind.DELETE);
                        if (tablePath != null) {
                            delete.setTableId(tablePath.toString());
                        }
                        out.collect((Object)delete);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown operation type '%s'.", op));
                    }
                }
            }
            catch (RuntimeException e) {
                if (this.ignoreParseErrors) break block20;
                throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)e);
            }
        }
    }

    private JsonNode getPayload(JsonNode jsonNode) {
        if (this.debeziumEnabledSchema) {
            return jsonNode.get("payload");
        }
        return jsonNode;
    }

    private JsonNode convertBytes(byte[] message) {
        try {
            return this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (IOException t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)t);
        }
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.debeziumRowConverter.serializeValue(root);
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowType;
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType databaseSchema) {
        return databaseSchema;
    }
}

