/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;

public class TablePlaceholder {
    public static final String REPLACE_DATABASE_NAME_KEY = "database_name";
    public static final String REPLACE_SCHEMA_NAME_KEY = "schema_name";
    public static final String REPLACE_SCHEMA_FULL_NAME_KEY = "schema_full_name";
    public static final String REPLACE_TABLE_NAME_KEY = "table_name";
    public static final String REPLACE_TABLE_FULL_NAME_KEY = "table_full_name";
    public static final String REPLACE_PRIMARY_KEY = "primary_key";
    public static final String REPLACE_UNIQUE_KEY = "unique_key";
    public static final String REPLACE_FIELD_NAMES_KEY = "field_names";
    public static final String NAME_DELIMITER = ".";
    public static final String FIELD_DELIMITER = ",";

    private static String replacePlaceholders(String input, String placeholderName, String value) {
        return TablePlaceholder.replacePlaceholders(input, placeholderName, value, null);
    }

    private static String replacePlaceholders(String input, String placeholderName, String value, String defaultValue) {
        String placeholderRegex = "\\$\\{" + Pattern.quote(placeholderName) + "(:[^}]*)?\\}";
        Pattern pattern = Pattern.compile(placeholderRegex);
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String string = value != null && !value.isEmpty() ? value : (replacement = matcher.group(1) != null ? matcher.group(1).substring(1).trim() : defaultValue);
            if (replacement == null) continue;
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String replaceTableIdentifier(String placeholder, TableIdentifier identifier, String defaultValue) {
        placeholder = TablePlaceholder.replacePlaceholders(placeholder, REPLACE_DATABASE_NAME_KEY, identifier.getDatabaseName(), defaultValue);
        placeholder = TablePlaceholder.replacePlaceholders(placeholder, REPLACE_SCHEMA_NAME_KEY, identifier.getSchemaName(), defaultValue);
        placeholder = TablePlaceholder.replacePlaceholders(placeholder, REPLACE_TABLE_NAME_KEY, identifier.getTableName(), defaultValue);
        ArrayList<String> fullPath = new ArrayList<String>();
        if (identifier.getDatabaseName() != null) {
            fullPath.add(identifier.getDatabaseName());
        }
        if (identifier.getSchemaName() != null) {
            fullPath.add(identifier.getSchemaName());
        }
        if (!fullPath.isEmpty()) {
            placeholder = TablePlaceholder.replacePlaceholders(placeholder, REPLACE_SCHEMA_FULL_NAME_KEY, String.join((CharSequence)NAME_DELIMITER, fullPath), defaultValue);
        }
        if (identifier.getTableName() != null) {
            fullPath.add(identifier.getTableName());
        }
        if (!fullPath.isEmpty()) {
            placeholder = TablePlaceholder.replacePlaceholders(placeholder, REPLACE_TABLE_FULL_NAME_KEY, String.join((CharSequence)NAME_DELIMITER, fullPath), defaultValue);
        }
        return placeholder;
    }

    public static String replaceTableIdentifier(String placeholder, TableIdentifier identifier) {
        return TablePlaceholder.replaceTableIdentifier(placeholder, identifier, "");
    }

    public static String replaceTablePrimaryKey(String placeholder, PrimaryKey primaryKey) {
        if (primaryKey != null && !primaryKey.getColumnNames().isEmpty()) {
            String pkFieldsString = String.join((CharSequence)FIELD_DELIMITER, primaryKey.getColumnNames());
            return TablePlaceholder.replacePlaceholders(placeholder, REPLACE_PRIMARY_KEY, pkFieldsString);
        }
        return placeholder;
    }

    public static String replaceTableUniqueKey(String placeholder, List<ConstraintKey> constraintKeys) {
        Optional<String> ukFieldsString = constraintKeys.stream().filter(e -> e.getConstraintType().equals((Object)ConstraintKey.ConstraintType.UNIQUE_KEY)).findFirst().map(e -> e.getColumnNames().stream().map(f -> f.getColumnName()).collect(Collectors.joining(FIELD_DELIMITER)));
        if (ukFieldsString.isPresent()) {
            return TablePlaceholder.replacePlaceholders(placeholder, REPLACE_UNIQUE_KEY, ukFieldsString.get());
        }
        return placeholder;
    }

    public static String replaceTableFieldNames(String placeholder, TableSchema schema) {
        return TablePlaceholder.replacePlaceholders(placeholder, REPLACE_FIELD_NAMES_KEY, String.join((CharSequence)FIELD_DELIMITER, schema.getFieldNames()));
    }

    public static ReadonlyConfig replaceTablePlaceholder(ReadonlyConfig config, CatalogTable table) {
        return TablePlaceholder.replaceTablePlaceholder(config, table, Collections.emptyList());
    }

    public static ReadonlyConfig replaceTablePlaceholder(ReadonlyConfig config, CatalogTable table, Collection<String> excludeKeys) {
        Map<String, Object> copyOnWriteData = ObjectUtils.clone(config.getSourceMap());
        for (String key : copyOnWriteData.keySet()) {
            List<String> listValue;
            Object value;
            if (excludeKeys.contains(key) || (value = copyOnWriteData.get(key)) == null) continue;
            if (value instanceof String) {
                String strValue = (String)value;
                strValue = TablePlaceholder.replaceTableIdentifier(strValue, table.getTableId());
                strValue = TablePlaceholder.replaceTablePrimaryKey(strValue, table.getTableSchema().getPrimaryKey());
                strValue = TablePlaceholder.replaceTableUniqueKey(strValue, table.getTableSchema().getConstraintKeys());
                strValue = TablePlaceholder.replaceTableFieldNames(strValue, table.getTableSchema());
                copyOnWriteData.put(key, strValue);
                continue;
            }
            if (!(value instanceof List) || (listValue = (List<String>)value).size() != 1 || !(listValue.get(0) instanceof String)) continue;
            String strValue = (String)listValue.get(0);
            if (strValue.equals("${primary_key}")) {
                strValue = TablePlaceholder.replaceTablePrimaryKey(strValue, table.getTableSchema().getPrimaryKey());
                listValue = Arrays.asList(strValue.split(FIELD_DELIMITER));
            } else if (strValue.equals("${unique_key}")) {
                strValue = TablePlaceholder.replaceTableUniqueKey(strValue, table.getTableSchema().getConstraintKeys());
                listValue = Arrays.asList(strValue.split(FIELD_DELIMITER));
            } else if (strValue.equals("${field_names}")) {
                strValue = TablePlaceholder.replaceTableFieldNames(strValue, table.getTableSchema());
                listValue = Arrays.asList(strValue.split(FIELD_DELIMITER));
            }
            copyOnWriteData.put(key, listValue);
        }
        return ReadonlyConfig.fromMap(copyOnWriteData);
    }
}

