/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;

public class SnapshotDiffReportListing {
    private final byte[] lastPath;
    private final int lastIndex;
    private final boolean isFromEarlier;
    private final List<DiffReportListingEntry> modifyList;
    private final List<DiffReportListingEntry> createList;
    private final List<DiffReportListingEntry> deleteList;

    public SnapshotDiffReportListing() {
        this.modifyList = Collections.emptyList();
        this.createList = Collections.emptyList();
        this.deleteList = Collections.emptyList();
        this.lastPath = DFSUtilClient.string2Bytes("");
        this.lastIndex = -1;
        this.isFromEarlier = false;
    }

    public SnapshotDiffReportListing(byte[] startPath, List<DiffReportListingEntry> modifiedEntryList, List<DiffReportListingEntry> createdEntryList, List<DiffReportListingEntry> deletedEntryList, int index, boolean isFromEarlier) {
        this.modifyList = modifiedEntryList;
        this.createList = createdEntryList;
        this.deleteList = deletedEntryList;
        this.lastPath = startPath != null ? startPath : DFSUtilClient.string2Bytes("");
        this.lastIndex = index;
        this.isFromEarlier = isFromEarlier;
    }

    public List<DiffReportListingEntry> getModifyList() {
        return this.modifyList;
    }

    public List<DiffReportListingEntry> getCreateList() {
        return this.createList;
    }

    public List<DiffReportListingEntry> getDeleteList() {
        return this.deleteList;
    }

    public byte[] getLastPath() {
        return this.lastPath;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean getIsFromEarlier() {
        return this.isFromEarlier;
    }

    public static class DiffReportListingEntry {
        private final long fileId;
        private final long dirId;
        private final boolean isReference;
        private final byte[][] sourcePath;
        private final byte[][] targetPath;

        public DiffReportListingEntry(long dirId, long fileId, byte[][] sourcePath, boolean isReference, byte[][] targetPath) {
            Preconditions.checkNotNull(sourcePath);
            this.dirId = dirId;
            this.fileId = fileId;
            this.sourcePath = sourcePath;
            this.isReference = isReference;
            this.targetPath = targetPath;
        }

        public DiffReportListingEntry(long dirId, long fileId, byte[] sourcePath, boolean isReference, byte[] targetpath) {
            Preconditions.checkNotNull(sourcePath);
            this.dirId = dirId;
            this.fileId = fileId;
            this.sourcePath = DFSUtilClient.bytes2byteArray(sourcePath);
            this.isReference = isReference;
            this.targetPath = targetpath == null ? (byte[][])null : DFSUtilClient.bytes2byteArray(targetpath);
        }

        public long getDirId() {
            return this.dirId;
        }

        public long getFileId() {
            return this.fileId;
        }

        public byte[][] getSourcePath() {
            return this.sourcePath;
        }

        public byte[][] getTargetPath() {
            return this.targetPath;
        }

        public boolean isReference() {
            return this.isReference;
        }
    }
}

