/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.metadata;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import net.sf.jsqlparser.util.validation.metadata.DatabaseMetaDataValidation;
import net.sf.jsqlparser.util.validation.metadata.Named;
import net.sf.jsqlparser.util.validation.metadata.NamesLookup;

public abstract class AbstractDatabaseMetaDataCapability
implements DatabaseMetaDataValidation {
    protected Connection connection;
    protected boolean cacheResults;
    protected Map<Named, Boolean> results = new HashMap<Named, Boolean>();
    protected UnaryOperator<String> namesLookup = NamesLookup.NO_TRANSFORMATION;

    public AbstractDatabaseMetaDataCapability(Connection connection, UnaryOperator<String> namesLookup) {
        this(connection, namesLookup, true);
    }

    public AbstractDatabaseMetaDataCapability(Connection connection, UnaryOperator<String> namesLookup, boolean cacheResults) {
        this.connection = connection;
        this.namesLookup = namesLookup;
        this.cacheResults = cacheResults;
    }

    public UnaryOperator<String> getNamesLookup() {
        return this.namesLookup;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isCacheResults() {
        return this.cacheResults;
    }

    public AbstractDatabaseMetaDataCapability clearCache() {
        this.results.clear();
        return this;
    }

    @Override
    public final boolean exists(Named named) {
        Objects.requireNonNull(named);
        named.setFqnLookup((String)this.getNamesLookup().apply(named.getFqn()));
        named.setAliasLookup((String)this.getNamesLookup().apply(named.getAlias()));
        switch (named.getNamedObject()) {
            case table: {
                return this.cache(named, this::tableExists);
            }
            case column: {
                return this.cache(named, this::columnExists);
            }
            case schema: {
                return this.cache(named, this::schemaExists);
            }
            case index: {
                return this.cache(named, this::indexExists);
            }
            case database: {
                return this.cache(named, this::databaseExists);
            }
            case constraint: 
            case uniqueConstraint: {
                return this.cache(named, this::constraintExists);
            }
            case view: {
                return this.cache(named, this::viewExists);
            }
            case procedure: {
                return this.cache(named, this::procedureExists);
            }
            case user: {
                return this.cache(named, this::userExists);
            }
            case role: {
                return this.cache(named, this::roleExists);
            }
        }
        throw new UnsupportedOperationException(named.getFqn() + ": evaluation of " + (Object)((Object)named.getNamedObject()) + "-name not implemented.");
    }

    protected boolean cache(Named named, BiPredicate<Map<Named, Boolean>, Named> fn) {
        Map<Named, Boolean> m3 = Collections.unmodifiableMap(this.results);
        if (this.cacheResults) {
            return this.results.computeIfAbsent(named, k -> fn.test(m3, (Named)k));
        }
        return fn.test(m3, named);
    }

    protected boolean roleExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean userExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean procedureExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean databaseExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean constraintExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean viewExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean indexExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean schemaExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean columnExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected boolean tableExists(Map<Named, Boolean> results, Named name) {
        throw this.unsupported(name);
    }

    protected UnsupportedOperationException unsupported(Named name) {
        return new UnsupportedOperationException(name.getFqn() + ": evaluation of " + (Object)((Object)name.getNamedObject()) + "-name not supported.");
    }
}

