/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.seatunnel.api.common.metrics.Measurement;

public final class MeasurementPredicates {
    private MeasurementPredicates() {
    }

    public static Predicate<Measurement> containsTag(String tag) {
        return measurement -> measurement.tag(tag) != null;
    }

    public static Predicate<Measurement> tagValueEquals(String tag, String value) {
        return measurement -> value.equals(measurement.tag(tag));
    }

    public static Predicate<Measurement> tagValueMatches(String tag, String valueRegexp) {
        return measurement -> {
            String value = measurement.tag(tag);
            return value != null && Pattern.compile(valueRegexp).matcher(value).matches();
        };
    }
}

