/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.env;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.seatunnel.engine.common.env.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtil {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentUtil.class);

    private static String getProperty(Properties properties, String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (value == null || value.charAt(0) == '$') {
            return defaultValue;
        }
        return value;
    }

    public static Version getVersion() {
        Version version = new Version();
        ClassLoader classLoader = EnvironmentUtil.class.getClassLoader();
        try (InputStream propFile = classLoader.getResourceAsStream("zeta.version.properties");){
            if (propFile != null) {
                Properties properties = new Properties();
                properties.load(propFile);
                version.setProjectVersion(EnvironmentUtil.getProperty(properties, "project.version", version.getProjectVersion()));
                version.setGitCommitId(EnvironmentUtil.getProperty(properties, "git.commit.id", version.getGitCommitId()));
                version.setGitCommitAbbrev(EnvironmentUtil.getProperty(properties, "git.commit.id.abbrev", version.getGitCommitAbbrev()));
                DateTimeFormatter gitDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
                DateTimeFormatter systemDefault = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
                version.setBuildTime(systemDefault.format(gitDateTimeFormatter.parse(EnvironmentUtil.getProperty(properties, "git.build.time", version.getBuildTime()))));
                version.setCommitTime(systemDefault.format(gitDateTimeFormatter.parse(EnvironmentUtil.getProperty(properties, "git.commit.time", version.getCommitTime()))));
            }
        }
        catch (IOException ioException) {
            log.info("Unable to read version property file: {}", (Object)ioException.getMessage());
        }
        return version;
    }
}

