/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DeployMode {
    CLIENT("client"),
    CLUSTER("cluster"),
    RUN("run"),
    RUN_APPLICATION("run-application");

    private final String deployMode;
    private static final Map<String, DeployMode> NAME_MAP;

    private DeployMode(String deployMode) {
        this.deployMode = deployMode;
    }

    public String getDeployMode() {
        return this.deployMode;
    }

    public static Optional<DeployMode> from(String deployMode) {
        return Optional.ofNullable(NAME_MAP.get(deployMode.toLowerCase()));
    }

    static {
        NAME_MAP = Arrays.stream(DeployMode.values()).collect(Collectors.toMap(DeployMode::getDeployMode, Function.identity()));
    }
}

