/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.split;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.split.SplitTransformConfig;
import org.apache.seatunnel.transform.split.SplitTransformFactory;

@AutoService(value={SeaTunnelTransform.class})
public class SplitTransform
extends MultipleFieldOutputTransform {
    private SplitTransformConfig splitTransformConfig;
    private int splitFieldIndex;

    public SplitTransform(@NonNull SplitTransformConfig splitTransformConfig, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (splitTransformConfig == null) {
            throw new NullPointerException("splitTransformConfig is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.splitTransformConfig = splitTransformConfig;
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.splitFieldIndex = seaTunnelRowType.indexOf(splitTransformConfig.getSplitField());
        if (this.splitFieldIndex == -1) {
            throw new IllegalArgumentException("Cannot find [" + splitTransformConfig.getSplitField() + "] field in input row type");
        }
        this.outputCatalogTable = this.getProducedCatalogTable();
    }

    public String getPluginName() {
        return "Split";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        ConfigValidator.of((ReadonlyConfig)ReadonlyConfig.fromConfig((Config)pluginConfig)).validate(new SplitTransformFactory().optionRule());
        this.splitTransformConfig = SplitTransformConfig.of(ReadonlyConfig.fromConfig((Config)pluginConfig));
    }

    @Override
    protected void setInputRowType(SeaTunnelRowType rowType) {
        this.splitFieldIndex = rowType.indexOf(this.splitTransformConfig.getSplitField());
        if (this.splitFieldIndex == -1) {
            throw new IllegalArgumentException("Cannot find [" + this.splitTransformConfig.getSplitField() + "] field in input row type");
        }
    }

    @Override
    protected String[] getOutputFieldNames() {
        return this.splitTransformConfig.getOutputFields();
    }

    @Override
    protected SeaTunnelDataType[] getOutputFieldDataTypes() {
        return (SeaTunnelDataType[])IntStream.range(0, this.splitTransformConfig.getOutputFields().length).mapToObj(value -> BasicType.STRING_TYPE).toArray(SeaTunnelDataType[]::new);
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object splitFieldValue = inputRow.getField(this.splitFieldIndex);
        if (splitFieldValue == null) {
            return this.splitTransformConfig.getEmptySplits();
        }
        Object[] splitFieldValues = splitFieldValue.toString().split(this.splitTransformConfig.getSeparator(), this.splitTransformConfig.getOutputFields().length);
        if (splitFieldValues.length < this.splitTransformConfig.getOutputFields().length) {
            Object[] tmp = splitFieldValues;
            splitFieldValues = new String[this.splitTransformConfig.getOutputFields().length];
            System.arraycopy(tmp, 0, splitFieldValues, 0, tmp.length);
        }
        return splitFieldValues;
    }

    @Override
    protected Column[] getOutputColumns() {
        List<Column> collect = Arrays.stream(this.splitTransformConfig.getOutputFields()).map((? super T fieldName) -> PhysicalColumn.of((String)fieldName, (SeaTunnelDataType)BasicType.STRING_TYPE, (Integer)200, (boolean)true, (Object)"", (String)"")).collect(Collectors.toList());
        return collect.toArray(new Column[0]);
    }

    public SplitTransform() {
    }
}

