/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.common;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;

public enum ExecutionStatus {
    SUBMITTED_SUCCESS(0, "submit success"),
    RUNNING_EXECUTION(1, "running"),
    READY_PAUSE(2, "ready pause"),
    PAUSE(3, "pause"),
    READY_STOP(4, "ready stop"),
    STOP(5, "stop"),
    FAILURE(6, "failure"),
    SUCCESS(7, "success"),
    NEED_FAULT_TOLERANCE(8, "need fault tolerance"),
    KILL(9, "kill"),
    WAITING_THREAD(10, "waiting thread"),
    WAITING_DEPEND(11, "waiting depend node complete"),
    DELAY_EXECUTION(12, "delay execution"),
    FORCED_SUCCESS(13, "forced success"),
    SERIAL_WAIT(14, "serial wait"),
    READY_BLOCK(15, "ready block"),
    BLOCK(16, "block"),
    DISPATCH(17, "dispatch"),
    PAUSE_BY_ISOLATION(18, "paused by isolation"),
    KILL_BY_ISOLATION(19, "killed by isolation"),
    PAUSE_BY_CORONATION(20, "paused by coronation"),
    FORBIDDEN_BY_CORONATION(21, "forbidden by coronation");

    @EnumValue
    private final int code;
    private final String descp;
    private static HashMap<Integer, ExecutionStatus> EXECUTION_STATUS_MAP;
    private static final int[] NEED_FAILOVER_STATES;

    private ExecutionStatus(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public boolean typeIsSuccess() {
        return this == SUCCESS || this == FORCED_SUCCESS || this == FORBIDDEN_BY_CORONATION;
    }

    public boolean typeIsFailure() {
        return this == FAILURE || this == NEED_FAULT_TOLERANCE;
    }

    public boolean typeIsFinished() {
        return this.typeIsSuccess() || this.typeIsFailure() || this.typeIsCancel() || this.typeIsPause() || this.typeIsPauseByIsolation() || this.typeIsStop() || this.typeIsBlock() || this.typeIsPauseByCoronation() || this.typeIsForbiddenByCoronation();
    }

    public boolean typeIsReady() {
        return this == READY_PAUSE || this == READY_STOP || this == READY_BLOCK;
    }

    public boolean typeIsWaitingThread() {
        return this == WAITING_THREAD;
    }

    public boolean typeIsPause() {
        return this == PAUSE;
    }

    public boolean typeIsPauseByIsolation() {
        return this == PAUSE_BY_ISOLATION;
    }

    public boolean typeIsPauseByCoronation() {
        return this == PAUSE_BY_CORONATION;
    }

    public boolean typeIsForbiddenByCoronation() {
        return this == FORBIDDEN_BY_CORONATION;
    }

    public boolean typeIsKilledByIsolation() {
        return this == KILL_BY_ISOLATION;
    }

    public boolean typeIsIsolated() {
        return this == PAUSE_BY_ISOLATION || this == KILL_BY_ISOLATION;
    }

    public boolean typeIsStop() {
        return this == STOP;
    }

    public boolean typeIsRunning() {
        return this == RUNNING_EXECUTION || this == WAITING_DEPEND || this == DELAY_EXECUTION;
    }

    public boolean typeIsBlock() {
        return this == BLOCK;
    }

    public boolean typeIsCancel() {
        return this == KILL || this == STOP || this == KILL_BY_ISOLATION;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static ExecutionStatus of(int status) {
        if (EXECUTION_STATUS_MAP.containsKey(status)) {
            return EXECUTION_STATUS_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid status : " + status);
    }

    public static boolean isNeedFailoverWorkflowInstanceState(ExecutionStatus executionStatus) {
        return SUBMITTED_SUCCESS == executionStatus || DISPATCH == executionStatus || RUNNING_EXECUTION == executionStatus || DELAY_EXECUTION == executionStatus || READY_PAUSE == executionStatus || READY_STOP == executionStatus;
    }

    public static int[] getNeedFailoverWorkflowInstanceState() {
        return NEED_FAILOVER_STATES;
    }

    public static int[] getRunningProcessState() {
        return new int[]{RUNNING_EXECUTION.getCode(), SUBMITTED_SUCCESS.getCode(), DISPATCH.getCode(), SERIAL_WAIT.getCode()};
    }

    public static int[] getNotTerminatedStates() {
        return new int[]{SUBMITTED_SUCCESS.getCode(), DISPATCH.getCode(), RUNNING_EXECUTION.getCode(), DELAY_EXECUTION.getCode(), READY_PAUSE.getCode(), READY_STOP.getCode(), NEED_FAULT_TOLERANCE.getCode(), WAITING_THREAD.getCode(), WAITING_DEPEND.getCode()};
    }

    public boolean canStop() {
        return this.typeIsRunning() || this == READY_PAUSE;
    }

    static {
        EXECUTION_STATUS_MAP = new HashMap();
        NEED_FAILOVER_STATES = new int[]{SUBMITTED_SUCCESS.ordinal(), DISPATCH.ordinal(), RUNNING_EXECUTION.ordinal(), DELAY_EXECUTION.ordinal(), READY_PAUSE.ordinal(), READY_STOP.ordinal()};
        for (ExecutionStatus executionStatus : ExecutionStatus.values()) {
            EXECUTION_STATUS_MAP.put(executionStatus.code, executionStatus);
        }
    }
}

