/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config.server;

import java.io.Serializable;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class CheckpointConfig
implements Serializable {
    public static final long MINIMAL_CHECKPOINT_TIME = 10L;
    private long checkpointInterval = ((Integer)ServerConfigOptions.CHECKPOINT_INTERVAL.defaultValue()).intValue();
    private long checkpointTimeout = ((Integer)ServerConfigOptions.CHECKPOINT_TIMEOUT.defaultValue()).intValue();
    private long schemaChangeCheckpointTimeout = ((Integer)ServerConfigOptions.SCHEMA_CHANGE_CHECKPOINT_TIMEOUT.defaultValue()).intValue();
    private CheckpointStorageConfig storage = (CheckpointStorageConfig)ServerConfigOptions.CHECKPOINT_STORAGE.defaultValue();
    private boolean checkpointEnable = true;

    public void setCheckpointInterval(long checkpointInterval) {
        Preconditions.checkArgument((checkpointInterval >= 10L ? 1 : 0) != 0, (Object)"The minimum checkpoint interval is 10 mills.");
        this.checkpointInterval = checkpointInterval;
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        Preconditions.checkArgument((checkpointTimeout >= 10L ? 1 : 0) != 0, (Object)"The minimum checkpoint timeout is 10 mills.");
        this.checkpointTimeout = checkpointTimeout;
    }

    public void setSchemaChangeCheckpointTimeout(long checkpointTimeout) {
        Preconditions.checkArgument((checkpointTimeout >= 10L ? 1 : 0) != 0, (Object)"The minimum checkpoint timeout is 10 ms.");
        this.schemaChangeCheckpointTimeout = checkpointTimeout;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public long getSchemaChangeCheckpointTimeout() {
        return this.schemaChangeCheckpointTimeout;
    }

    public CheckpointStorageConfig getStorage() {
        return this.storage;
    }

    public boolean isCheckpointEnable() {
        return this.checkpointEnable;
    }

    public void setStorage(CheckpointStorageConfig storage) {
        this.storage = storage;
    }

    public void setCheckpointEnable(boolean checkpointEnable) {
        this.checkpointEnable = checkpointEnable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointConfig)) {
            return false;
        }
        CheckpointConfig other = (CheckpointConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCheckpointInterval() != other.getCheckpointInterval()) {
            return false;
        }
        if (this.getCheckpointTimeout() != other.getCheckpointTimeout()) {
            return false;
        }
        if (this.getSchemaChangeCheckpointTimeout() != other.getSchemaChangeCheckpointTimeout()) {
            return false;
        }
        if (this.isCheckpointEnable() != other.isCheckpointEnable()) {
            return false;
        }
        CheckpointStorageConfig this$storage = this.getStorage();
        CheckpointStorageConfig other$storage = other.getStorage();
        return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $checkpointInterval = this.getCheckpointInterval();
        result = result * 59 + (int)($checkpointInterval >>> 32 ^ $checkpointInterval);
        long $checkpointTimeout = this.getCheckpointTimeout();
        result = result * 59 + (int)($checkpointTimeout >>> 32 ^ $checkpointTimeout);
        long $schemaChangeCheckpointTimeout = this.getSchemaChangeCheckpointTimeout();
        result = result * 59 + (int)($schemaChangeCheckpointTimeout >>> 32 ^ $schemaChangeCheckpointTimeout);
        result = result * 59 + (this.isCheckpointEnable() ? 79 : 97);
        CheckpointStorageConfig $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        return result;
    }

    public String toString() {
        return "CheckpointConfig(checkpointInterval=" + this.getCheckpointInterval() + ", checkpointTimeout=" + this.getCheckpointTimeout() + ", schemaChangeCheckpointTimeout=" + this.getSchemaChangeCheckpointTimeout() + ", storage=" + this.getStorage() + ", checkpointEnable=" + this.isCheckpointEnable() + ")";
    }
}

