/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config.server;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarHAStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageMode;
import org.apache.seatunnel.engine.common.config.server.QueueType;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.apache.seatunnel.engine.common.config.server.TelemetryConfig;
import org.apache.seatunnel.engine.common.config.server.TelemetryMetricConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;

public class ServerConfigOptions {
    public static final Option<Integer> BACKUP_COUNT = Options.key((String)"backup-count").intType().defaultValue((Object)1).withDescription("The number of backup copies of each partition.");
    public static final Option<Integer> PRINT_EXECUTION_INFO_INTERVAL = Options.key((String)"print-execution-info-interval").intType().defaultValue((Object)60).withDescription("The interval (in seconds) between two consecutive executions of the print execution info task.");
    public static final Option<Integer> PRINT_JOB_METRICS_INFO_INTERVAL = Options.key((String)"print-job-metrics-info-interval").intType().defaultValue((Object)60).withDescription("The interval (in seconds) of job print metrics info");
    public static final Option<Integer> JOB_METRICS_BACKUP_INTERVAL = Options.key((String)"job-metrics-backup-interval").intType().defaultValue((Object)10).withDescription("The interval (in seconds) of job metrics backups");
    public static final Option<ThreadShareMode> TASK_EXECUTION_THREAD_SHARE_MODE = Options.key((String)"task_execution_thread_share_mode").type((TypeReference)new TypeReference<ThreadShareMode>(){}).defaultValue((Object)ThreadShareMode.OFF).withDescription("The thread sharing mode of TaskExecutionServer, including ALL, OFF, PART. Default is OFF");
    public static final Option<Boolean> DYNAMIC_SLOT = Options.key((String)"dynamic-slot").booleanType().defaultValue((Object)true).withDescription("Whether to use dynamic slot.");
    public static final Option<Integer> SLOT_NUM = Options.key((String)"slot-num").intType().defaultValue((Object)2).withDescription("The number of slots. Only valid when dynamic slot is disabled.");
    public static final Option<Integer> CHECKPOINT_INTERVAL = Options.key((String)"interval").intType().defaultValue((Object)300000).withDescription("The interval (in milliseconds) between two consecutive checkpoints.");
    public static final Option<Integer> CHECKPOINT_TIMEOUT = Options.key((String)"timeout").intType().defaultValue((Object)30000).withDescription("The timeout (in milliseconds) for a checkpoint.");
    public static final Option<Integer> SCHEMA_CHANGE_CHECKPOINT_TIMEOUT = Options.key((String)"schema-change-timeout").intType().defaultValue((Object)30000).withDescription("The timeout (in milliseconds) for a schema change checkpoint.");
    public static final Option<String> CHECKPOINT_STORAGE_TYPE = Options.key((String)"type").stringType().defaultValue((Object)"localfile").withDescription("The checkpoint storage type.");
    public static final Option<Integer> CHECKPOINT_STORAGE_MAX_RETAINED = Options.key((String)"max-retained").intType().defaultValue((Object)20).withDescription("The maximum number of retained checkpoints.");
    public static final Option<QueueType> QUEUE_TYPE = Options.key((String)"queue-type").type((TypeReference)new TypeReference<QueueType>(){}).defaultValue((Object)QueueType.BLOCKINGQUEUE).withDescription("The internal data cache queue type.");
    public static final Option<CheckpointStorageConfig> CHECKPOINT_STORAGE = Options.key((String)"storage").type((TypeReference)new TypeReference<CheckpointStorageConfig>(){}).defaultValue((Object)new CheckpointStorageConfig()).withDescription("The checkpoint storage configuration.");
    public static final Option<SlotServiceConfig> SLOT_SERVICE = Options.key((String)"slot-service").type((TypeReference)new TypeReference<SlotServiceConfig>(){}).defaultValue((Object)new SlotServiceConfig()).withDescription("The slot service configuration.");
    public static final Option<CheckpointConfig> CHECKPOINT = Options.key((String)"checkpoint").type((TypeReference)new TypeReference<CheckpointConfig>(){}).defaultValue((Object)new CheckpointConfig()).withDescription("The checkpoint configuration.");
    public static final Option<Map<String, String>> CHECKPOINT_STORAGE_PLUGIN_CONFIG = Options.key((String)"plugin-config").type((TypeReference)new TypeReference<Map<String, String>>(){}).noDefaultValue().withDescription("The checkpoint storage instance configuration.");
    public static final Option<Integer> HISTORY_JOB_EXPIRE_MINUTES = Options.key((String)"history-job-expire-minutes").intType().defaultValue((Object)1440).withDescription("The expire time of history jobs.time unit minute");
    public static final Option<Boolean> ENABLE_CONNECTOR_JAR_STORAGE = Options.key((String)"enable").booleanType().defaultValue((Object)Boolean.FALSE).withDescription("Enable the engine server Jar package storage service, automatically upload connector Jar packages and dependent third-party Jar packages to the server before job execution. Enabling this configuration does not require the server to hold all connector Jar packages");
    public static final Option<ConnectorJarStorageMode> CONNECTOR_JAR_STORAGE_MODE = Options.key((String)"connector-jar-storage-mode").enumType(ConnectorJarStorageMode.class).defaultValue((Object)ConnectorJarStorageMode.SHARED).withDescription("The storage mode of the connector jar package, including SHARED, ISOLATED. Default is SHARED");
    public static final Option<String> CONNECTOR_JAR_STORAGE_PATH = Options.key((String)"connector-jar-storage-path").stringType().defaultValue((Object)"").withDescription("The user defined connector jar storage path.");
    public static final Option<Integer> CONNECTOR_JAR_CLEANUP_TASK_INTERVAL = Options.key((String)"connector-jar-cleanup-task-interval").intType().defaultValue((Object)3600).withDescription("The user defined connector jar cleanup task interval.");
    public static final Option<Integer> CONNECTOR_JAR_EXPIRY_TIME = Options.key((String)"connector-jar-expiry-time").intType().defaultValue((Object)600).withDescription("The user defined connector jar expiry time.");
    public static final Option<String> CONNECTOR_JAR_HA_STORAGE_TYPE = Options.key((String)"type").stringType().defaultValue((Object)"localfile").withDescription("The connector jar HA storage type.");
    public static final Option<Map<String, String>> CONNECTOR_JAR_HA_STORAGE_PLUGIN_CONFIG = Options.key((String)"plugin-config").mapType().noDefaultValue().withDescription("The connector jar HA storage instance configuration.");
    public static final Option<ConnectorJarHAStorageConfig> CONNECTOR_JAR_HA_STORAGE_CONFIG = Options.key((String)"jar-ha-storage").type((TypeReference)new TypeReference<ConnectorJarHAStorageConfig>(){}).defaultValue((Object)new ConnectorJarHAStorageConfig()).withDescription("The connector jar ha storage configuration.");
    public static final Option<ConnectorJarStorageConfig> CONNECTOR_JAR_STORAGE_CONFIG = Options.key((String)"jar-storage").type((TypeReference)new TypeReference<ConnectorJarStorageConfig>(){}).defaultValue((Object)new ConnectorJarStorageConfig()).withDescription("The connector jar storage configuration.");
    public static final Option<Boolean> CLASSLOADER_CACHE_MODE = Options.key((String)"classloader-cache-mode").booleanType().defaultValue((Object)false).withDescription("Whether to use classloader cache mode. With cache mode, all jobs share the same classloader if the jars are the same");
    public static final Option<Boolean> TELEMETRY_METRIC_ENABLED = Options.key((String)"enabled").booleanType().defaultValue((Object)false).withDescription("Whether open metrics export.");
    public static final Option<TelemetryMetricConfig> TELEMETRY_METRIC = Options.key((String)"metric").type((TypeReference)new TypeReference<TelemetryMetricConfig>(){}).defaultValue((Object)new TelemetryMetricConfig()).withDescription("The telemetry metric configuration.");
    public static final Option<TelemetryConfig> TELEMETRY = Options.key((String)"telemetry").type((TypeReference)new TypeReference<TelemetryConfig>(){}).defaultValue((Object)new TelemetryConfig()).withDescription("The telemetry configuration.");
    public static final String EVENT_REPORT_HTTP = "event-report-http";
    public static final String EVENT_REPORT_HTTP_URL = "url";
    public static final String EVENT_REPORT_HTTP_HEADERS = "headers";
}

