/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.function.BiConsumer;

class ClusterInfoCollector
implements MetricsCollector {
    ClusterInfoCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        ClusterServiceImpl clusterService = node.getClusterService();
        int clusterSize = clusterService.getMembers().size();
        long clusterUpTime = clusterService.getClusterClock().getClusterUpTime();
        int partitionCount = node.getPartitionService().getPartitionCount();
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        metricsConsumer.accept(PhoneHomeMetrics.UUID_OF_CLUSTER, node.getThisUuid().toString());
        metricsConsumer.accept(PhoneHomeMetrics.CLUSTER_ID, clusterService.getClusterId().toString());
        metricsConsumer.accept(PhoneHomeMetrics.CLUSTER_SIZE, MetricsCollector.convertToLetter(clusterSize));
        metricsConsumer.accept(PhoneHomeMetrics.EXACT_CLUSTER_SIZE, String.valueOf(clusterSize));
        metricsConsumer.accept(PhoneHomeMetrics.TIME_TAKEN_TO_CLUSTER_UP, Long.toString(clusterUpTime));
        metricsConsumer.accept(PhoneHomeMetrics.UPTIME_OF_RUNTIME_MXBEAN, Long.toString(rt.getUptime()));
        metricsConsumer.accept(PhoneHomeMetrics.RUNTIME_MXBEAN_VM_NAME, rt.getVmName());
        metricsConsumer.accept(PhoneHomeMetrics.PARTITION_COUNT, String.valueOf(partitionCount));
    }
}

