/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.env.ParsingMode;
import org.apache.seatunnel.app.bean.connector.ConnectorCache;
import org.apache.seatunnel.app.config.ConnectorDataSourceMapperConfig;
import org.apache.seatunnel.app.dal.dao.IJobDefinitionDao;
import org.apache.seatunnel.app.dal.dao.IJobInstanceDao;
import org.apache.seatunnel.app.dal.dao.IJobLineDao;
import org.apache.seatunnel.app.dal.dao.IJobTaskDao;
import org.apache.seatunnel.app.dal.dao.IJobVersionDao;
import org.apache.seatunnel.app.dal.entity.JobDefinition;
import org.apache.seatunnel.app.dal.entity.JobInstance;
import org.apache.seatunnel.app.dal.entity.JobLine;
import org.apache.seatunnel.app.dal.entity.JobTask;
import org.apache.seatunnel.app.dal.entity.JobVersion;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.connector.SceneMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.DatabaseTableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.JobExecParam;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.request.job.TableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.domain.response.datasource.DatasourceDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.domain.response.executor.JobExecutorRes;
import org.apache.seatunnel.app.service.IDatasourceService;
import org.apache.seatunnel.app.service.IJobInstanceService;
import org.apache.seatunnel.app.service.IJobMetricsService;
import org.apache.seatunnel.app.service.IVirtualTableService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcherUtils;
import org.apache.seatunnel.app.thirdparty.transfrom.TransformConfigSwitcherUtils;
import org.apache.seatunnel.app.utils.JobUtils;
import org.apache.seatunnel.app.utils.SeaTunnelConfigUtil;
import org.apache.seatunnel.app.utils.TaskOptionUtils;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.core.job.JobResult;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigList;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JobInstanceServiceImpl
extends SeatunnelBaseServiceImpl
implements IJobInstanceService {
    private static final Logger log = LoggerFactory.getLogger(JobInstanceServiceImpl.class);
    private static final String DAG_PARSING_MODE = "dag-parsing.mode";
    @Resource
    private ConnectorDataSourceMapperConfig dataSourceMapperConfig;
    @Resource
    private IDatasourceService datasourceService;
    @Resource
    private IVirtualTableService virtualTableService;
    @Resource
    private IJobInstanceDao jobInstanceDao;
    @Resource
    private IJobDefinitionDao jobDefinitionDao;
    @Resource
    private ConnectorCache connectorCache;
    @Resource
    private IJobVersionDao jobVersionDao;
    @Resource
    private IJobTaskDao jobTaskDao;
    @Resource
    private IJobLineDao jobLineDao;
    @Resource
    private IJobMetricsService jobMetricsService;

    @Override
    public JobExecutorRes createExecuteResource(@NonNull Integer userId, @NonNull Long jobDefineId, JobExecParam executeParam) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobDefineId == null) {
            throw new NullPointerException("jobDefineId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task:job-exec-resource", userId);
        log.info("receive createExecuteResource request, userId:{}, jobDefineId:{}", (Object)userId, (Object)jobDefineId);
        JobDefinition job = this.jobDefinitionDao.getJob(jobDefineId);
        JobVersion latestVersion = this.jobVersionDao.getLatestVersion(job.getId());
        JobInstance jobInstance = new JobInstance();
        String jobConfig = this.createJobConfig(latestVersion, executeParam);
        try {
            jobInstance.setId(CodeGenerateUtils.getInstance().genCode());
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            throw new SeatunnelException(SeatunnelErrorEnum.JOB_RUN_GENERATE_UUID_ERROR);
        }
        jobInstance.setJobDefineId(job.getId());
        jobInstance.setEngineName(latestVersion.getEngineName());
        jobInstance.setEngineVersion(latestVersion.getEngineVersion());
        jobInstance.setJobConfig(jobConfig);
        jobInstance.setCreateUserId(userId);
        jobInstance.setJobType(latestVersion.getJobMode());
        this.jobInstanceDao.insert(jobInstance);
        return new JobExecutorRes(jobInstance.getId(), jobInstance.getJobConfig(), jobInstance.getEngineName(), null, null, jobInstance.getJobType());
    }

    @Override
    public String generateJobConfig(Long jobId, List<JobTask> tasks, List<JobLine> lines, String envStr, JobExecParam executeParam) {
        this.checkSceneMode(tasks);
        BusinessMode businessMode = BusinessMode.valueOf(this.jobDefinitionDao.getJob(jobId).getJobType());
        Config envConfig = this.filterEmptyValue(ConfigFactory.parseString((String)envStr));
        JobUtils.updateDataSource(executeParam, tasks);
        LinkedHashMap<String, List<Config>> sourceMap = new LinkedHashMap<String, List<Config>>();
        LinkedHashMap<String, List<Config>> transformMap = new LinkedHashMap<String, List<Config>>();
        LinkedHashMap<String, List<Config>> sinkMap = new LinkedHashMap<String, List<Config>>();
        Map inputLines = lines.stream().collect(Collectors.toMap(JobLine::getInputPluginId, Function.identity()));
        Map targetLines = lines.stream().collect(Collectors.toMap(JobLine::getTargetPluginId, Function.identity()));
        block8: for (JobTask task : tasks) {
            PluginType pluginType = PluginType.valueOf((String)task.getType().toUpperCase(Locale.ROOT));
            try {
                String pluginId = task.getPluginId();
                OptionRule optionRule = this.connectorCache.getOptionRule(pluginType.getType(), task.getConnectorType());
                Config config = this.filterEmptyValue(this.parseConfigWithOptionRule(pluginType, task.getConnectorType(), task.getConfig(), optionRule));
                switch (pluginType) {
                    case SOURCE: {
                        if (!inputLines.containsKey(pluginId)) continue block8;
                        config = this.addTableName(CommonOptions.RESULT_TABLE_NAME.key(), (JobLine)inputLines.get(pluginId), config);
                        if (!sourceMap.containsKey(task.getConnectorType())) {
                            sourceMap.put(task.getConnectorType(), new ArrayList());
                        }
                        if (businessMode.equals((Object)BusinessMode.DATA_REPLICA)) {
                            config = config.withValue(DAG_PARSING_MODE, ConfigValueFactory.fromAnyRef((Object)ParsingMode.MULTIPLEX.name()));
                        }
                        if (task.getSceneMode().toUpperCase().equals(SceneMode.SPLIT_TABLE.name())) {
                            config = config.withValue(DAG_PARSING_MODE, ConfigValueFactory.fromAnyRef((Object)ParsingMode.SHARDING.name()));
                        }
                        Config mergeConfig = this.mergeTaskConfig(task, pluginType, task.getConnectorType(), businessMode, config, optionRule);
                        ((List)sourceMap.get(task.getConnectorType())).add(this.filterEmptyValue(mergeConfig));
                        break;
                    }
                    case TRANSFORM: {
                        if (!inputLines.containsKey(pluginId) && !targetLines.containsKey(pluginId)) break;
                        if (inputLines.containsKey(pluginId)) {
                            config = this.addTableName(CommonOptions.RESULT_TABLE_NAME.key(), (JobLine)inputLines.get(pluginId), config);
                        }
                        if (targetLines.containsKey(pluginId)) {
                            config = this.addTableName(CommonOptions.SOURCE_TABLE_NAME.key(), (JobLine)targetLines.get(pluginId), config);
                        }
                        if (!transformMap.containsKey(task.getConnectorType())) {
                            transformMap.put(task.getConnectorType(), new ArrayList());
                        }
                        List<TableSchemaReq> inputSchemas = this.findInputSchemas(tasks, lines, task);
                        Config transformConfig = this.buildTransformConfig(task, config, inputSchemas);
                        ((List)transformMap.get(task.getConnectorType())).add(this.filterEmptyValue(transformConfig));
                        break;
                    }
                    case SINK: {
                        if (!targetLines.containsKey(pluginId)) continue block8;
                        config = this.addTableName(CommonOptions.SOURCE_TABLE_NAME.key(), (JobLine)targetLines.get(pluginId), config);
                        if (!sinkMap.containsKey(task.getConnectorType())) {
                            sinkMap.put(task.getConnectorType(), new ArrayList());
                        }
                        Config mergeConfig = this.mergeTaskConfig(task, pluginType, task.getConnectorType(), businessMode, config, optionRule);
                        ((List)sinkMap.get(task.getConnectorType())).add(this.filterEmptyValue(mergeConfig));
                        break;
                    }
                    default: {
                        throw new SeatunnelException(SeatunnelErrorEnum.UNSUPPORTED_CONNECTOR_TYPE, new Object[]{task.getType().toUpperCase()});
                    }
                }
            }
            catch (SeatunnelException e) {
                log.error(ExceptionUtils.getMessage((Throwable)e));
                throw e;
            }
            catch (Exception e) {
                throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{String.format("Plugin Type: %s, Connector Type: %s, Error Info: %s", pluginType, task.getConnectorType(), ExceptionUtils.getMessage((Throwable)e))});
            }
        }
        String sources = "";
        if (sourceMap.size() > 0) {
            sources = this.getConnectorConfig(sourceMap);
        }
        String transforms = "";
        if (transformMap.size() > 0) {
            transforms = this.getConnectorConfig(transformMap);
        }
        String sinks = "";
        if (sinkMap.size() > 0) {
            sinks = this.getConnectorConfig(sinkMap);
        }
        String env = envConfig.root().render(ConfigRenderOptions.defaults().setJson(false).setComments(false).setOriginComments(false));
        String jobConfig = SeaTunnelConfigUtil.generateConfig(env, sources, transforms, sinks);
        return JobUtils.replaceJobConfigPlaceholders(jobConfig, executeParam);
    }

    @Override
    public JobExecutorRes getExecuteResource(@NonNull Long jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task:job-exec-instance", 0);
        JobInstance jobInstance = this.jobInstanceDao.getJobInstanceByEngineId(jobEngineId);
        return new JobExecutorRes(jobInstance.getId(), jobInstance.getJobConfig(), jobInstance.getEngineName(), null, null, jobInstance.getJobType());
    }

    @Override
    public void complete(@NonNull Integer userId, @NonNull Long jobInstanceId, @NonNull String jobEngineId, JobResult jobResult) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task:job-exec-complete", userId);
        JobInstance jobInstance = (JobInstance)this.jobInstanceDao.getJobInstanceMapper().selectById(jobInstanceId);
        this.jobMetricsService.syncJobDataToDb(jobInstance, userId, jobEngineId);
        jobInstance.setJobStatus(jobResult.getStatus());
        jobInstance.setJobEngineId(jobEngineId);
        jobInstance.setUpdateUserId(userId);
        jobInstance.setErrorMessage(JobUtils.getJobInstanceErrorMessage(jobResult.getError()));
        this.jobInstanceDao.update(jobInstance);
    }

    private Config buildTransformConfig(JobTask task, Config config, List<TableSchemaReq> inputSchemas) {
        try {
            Transform transform = Transform.valueOf(task.getConnectorType().toUpperCase());
            Object transformOption = TaskOptionUtils.getTransformOption(transform, task.getTransformOptions());
            return TransformConfigSwitcherUtils.mergeTransformConfig(transform, inputSchemas, config, transformOption);
        }
        catch (IOException e) {
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{e.getMessage()});
        }
    }

    private List<TableSchemaReq> findInputSchemas(List<JobTask> tasks, List<JobLine> lines, JobTask task) {
        ArrayList outputSchemas = new ArrayList();
        lines.forEach(jobLine -> {
            if (jobLine.getTargetPluginId().equals(task.getPluginId())) {
                String inputPluginId = jobLine.getInputPluginId();
                tasks.forEach(jobTask -> {
                    if (jobTask.getPluginId().equals(inputPluginId)) {
                        outputSchemas.add(jobTask.getOutputSchema());
                    }
                });
            }
        });
        Preconditions.checkArgument((outputSchemas.size() == 1 ? 1 : 0) != 0, (Object)"input schema size must be 1");
        List databaseTableSchemaReqs = (List)JsonUtils.parseObject((String)((String)outputSchemas.get(0)), (TypeReference)new TypeReference<List<DatabaseTableSchemaReq>>(){});
        return databaseTableSchemaReqs.stream().map(databaseTableSchemaReq -> {
            TableSchemaReq tableSchemaReq = new TableSchemaReq();
            tableSchemaReq.setTableName(databaseTableSchemaReq.getTableName());
            tableSchemaReq.setFields(databaseTableSchemaReq.getFields());
            return tableSchemaReq;
        }).collect(Collectors.toList());
    }

    private Config mergeTaskConfig(JobTask task, PluginType pluginType, String connectorType, BusinessMode businessMode, Config connectorConfig, OptionRule optionRule) throws JsonProcessingException {
        String tableName;
        Long datasourceInstanceId = task.getDataSourceId();
        DatasourceDetailRes datasourceDetailRes = this.datasourceService.queryDatasourceDetailById(datasourceInstanceId.toString());
        String pluginName = datasourceDetailRes.getPluginName();
        Config datasourceConf = this.parseConfigWithOptionRule(pluginType, connectorType, datasourceDetailRes.getDatasourceConfig(), optionRule);
        DataSourceOption dataSourceOption = task.getDataSourceOption() == null ? null : (DataSourceOption)JsonUtils.parseObject((String)task.getDataSourceOption(), DataSourceOption.class);
        SelectTableFields selectTableFields = task.getSelectTableFields() == null ? null : (SelectTableFields)JsonUtils.parseObject((String)task.getSelectTableFields(), SelectTableFields.class);
        SceneMode sceneMode = task.getSceneMode() == null ? null : SceneMode.valueOf(task.getSceneMode());
        VirtualTableDetailRes virtualTableDetailRes = null;
        if (!SceneMode.MULTIPLE_TABLE.equals((Object)sceneMode) && dataSourceOption != null && CollectionUtils.isNotEmpty(dataSourceOption.getTables()) && this.virtualTableService.containsVirtualTableByTableName(tableName = dataSourceOption.getTables().get(0))) {
            virtualTableDetailRes = this.virtualTableService.queryVirtualTableByTableName(tableName);
        }
        return DataSourceConfigSwitcherUtils.mergeDatasourceConfig(pluginName, datasourceConf, virtualTableDetailRes, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }

    private String createJobConfig(@NonNull JobVersion jobVersion, JobExecParam executeParam) {
        if (jobVersion == null) {
            throw new NullPointerException("jobVersion is marked non-null but is null");
        }
        List<JobTask> tasks = this.jobTaskDao.getTasksByVersionId(jobVersion.getId());
        List<JobLine> lines = this.jobLineDao.getLinesByVersionId(jobVersion.getId());
        return this.generateJobConfig(jobVersion.getJobId(), tasks, lines, jobVersion.getEnv(), executeParam);
    }

    private String getConnectorConfig(Map<String, List<Config>> connectorMap) {
        ArrayList<String> configs = new ArrayList<String>();
        ConfigRenderOptions configRenderOptions = ConfigRenderOptions.defaults().setJson(false).setComments(false).setOriginComments(false);
        for (Map.Entry<String, List<Config>> entry : connectorMap.entrySet()) {
            for (Config c : entry.getValue()) {
                configs.add(ConfigFactory.empty().withValue(entry.getKey(), (ConfigValue)c.root()).root().render(configRenderOptions));
            }
        }
        return StringUtils.join(configs, (String)"\n");
    }

    private Config addTableName(String tableName, JobLine jobLine, Config config) {
        return config.withValue(tableName, ConfigValueFactory.fromAnyRef((Object)("Table" + jobLine.getId())));
    }

    private Config filterEmptyValue(Config config) {
        List removeKeys = config.entrySet().stream().filter(entry -> this.isEmptyValue((ConfigValue)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        for (String removeKey : removeKeys) {
            config = config.withoutPath(removeKey);
        }
        return config;
    }

    private void checkSceneMode(List<JobTask> tasks) {
        HashSet sceneModes = new HashSet();
        HashMap<PluginType, Set> dataSourceIds = new HashMap<PluginType, Set>();
        tasks.forEach(jobTask -> {
            PluginType pluginType = PluginType.valueOf((String)jobTask.getType().toUpperCase(Locale.ROOT));
            if (pluginType.equals((Object)PluginType.SOURCE) || pluginType.equals((Object)PluginType.SINK)) {
                dataSourceIds.computeIfAbsent(pluginType, n -> new HashSet()).add(jobTask.getDataSourceId());
                if (pluginType.equals((Object)PluginType.SOURCE)) {
                    sceneModes.add(jobTask.getSceneMode());
                }
            }
        });
        if (sceneModes.size() != 1) {
            throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{String.format("Does not support multiple sceneMode in a job, sceneModes: %s", String.join((CharSequence)", ", sceneModes))});
        }
        SceneMode sceneMode = SceneMode.valueOf(((String)sceneModes.iterator().next()).toUpperCase(Locale.ROOT));
        dataSourceIds.forEach((pluginType, dataSourceIdList) -> dataSourceIdList.forEach(id -> {
            String pluginName = this.datasourceService.queryDatasourceDetailById(id.toString()).getPluginName();
            List<SceneMode> supportedSceneMode = this.dataSourceMapperConfig.supportedSceneMode(pluginName, (PluginType)pluginType).orElseThrow(() -> new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"Unsupported Data connector Name"}));
            if (!supportedSceneMode.contains((Object)sceneMode)) {
                throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{String.format("%s not support %s sceneMode", new Object[]{pluginName, sceneMode})});
            }
        }));
    }

    private boolean isEmptyValue(ConfigValue value) {
        return value.unwrapped().toString().isEmpty() || value.valueType().equals((Object)ConfigValueType.NULL);
    }

    private Config parseConfigWithOptionRule(PluginType pluginType, String connectorType, String config, OptionRule optionRule) {
        return this.parseConfigWithOptionRule(pluginType, connectorType, ConfigFactory.parseString((String)config), optionRule);
    }

    private Config parseConfigWithOptionRule(PluginType pluginType, String connectorType, Map<String, String> config, OptionRule optionRule) {
        return this.parseConfigWithOptionRule(pluginType, connectorType, ConfigFactory.parseMap(config), optionRule);
    }

    private Config parseConfigWithOptionRule(PluginType pluginType, String connectorType, Config config, OptionRule optionRule) {
        HashMap typeReferenceMap = new HashMap();
        optionRule.getOptionalOptions().forEach(option -> typeReferenceMap.put(option.key(), option.typeReference()));
        optionRule.getRequiredOptions().forEach(options -> options.getOptions().forEach(option -> typeReferenceMap.put(option.key(), option.typeReference())));
        HashMap needReplaceMap = new HashMap();
        HashMap needReplaceList = new HashMap();
        config.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            ConfigValue configValue = (ConfigValue)entry.getValue();
            try {
                if (typeReferenceMap.containsKey(key) && this.isComplexType((TypeReference)typeReferenceMap.get(key)) && !this.isEmptyValue(configValue)) {
                    String valueStr = configValue.unwrapped().toString();
                    if (((TypeReference)typeReferenceMap.get(key)).getType().getTypeName().startsWith("java.util.List") || ((TypeReference)typeReferenceMap.get(key)).getType().getTypeName().startsWith("org.apache.seatunnel.api.configuration.Options")) {
                        String valueWrapper = "{key=" + valueStr + "}";
                        ConfigList configList = ConfigFactory.parseString((String)valueWrapper).getList("key");
                        needReplaceList.put(key, configList);
                    } else {
                        Config configObject = ConfigFactory.parseString((String)valueStr);
                        needReplaceMap.put(key, configObject.root());
                    }
                }
            }
            catch (Exception e) {
                throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{String.format("Plugin Type: %s, Connector Type: %s, Key: %s, Error Info: %s", pluginType, connectorType, key, e.getMessage())});
            }
        });
        for (Map.Entry entry2 : needReplaceMap.entrySet()) {
            config = config.withValue((String)entry2.getKey(), (ConfigValue)entry2.getValue());
        }
        for (Map.Entry entry2 : needReplaceList.entrySet()) {
            config = config.withValue((String)entry2.getKey(), (ConfigValue)entry2.getValue());
        }
        return config;
    }

    private boolean isComplexType(TypeReference<?> typeReference) {
        return typeReference.getType().getTypeName().startsWith("java.util.List") || typeReference.getType().getTypeName().startsWith("java.util.Map") || typeReference.getType().getTypeName().startsWith("org.apache.seatunnel.api.configuration.Options");
    }
}

