
#include <gtest/gtest.h>

#include "s2geography.h"

using namespace s2geography;

void wkbRoundTrip(const std::string wktIn, const std::vector<uint8_t> &wkbIn) {
  WKTWriter wkt_writer(2);
  WKBReader reader;
  WKBWriter writer;

  auto geog = reader.ReadFeature(wkbIn.data(), wkbIn.size());
  auto wkbOut = writer.WriteFeature(*geog);
  auto geogOut = reader.ReadFeature(wkbOut);
  std::string wktOut = wkt_writer.write_feature(*geogOut);
  EXPECT_EQ(wktOut, wktIn);
}

TEST(WKBRoundtrip, Point) {
  std::string wkt("POINT (30 10)");
  std::vector<uint8_t> wkb({0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40});
  wkbRoundTrip(wkt, wkb);
}

TEST(WKBRoundtrip, LineString) {
  std::string wkt("LINESTRING (30 10, 12 42)");
  std::vector<uint8_t> wkb(
      {0x01, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
       0x00, 0x24, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x40,
       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x40});
  wkbRoundTrip(wkt, wkb);
}

TEST(WKBRoundtrip, Polygon) {
  std::string wkt(
      "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10), (20 30, 35 35, 30 20, 20 "
      "30))");
  std::vector<uint8_t> wkb(
      {0x01, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41, 0x40, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x24, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x46,
       0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x46, 0x40, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x2e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44,
       0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x34, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41,
       0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x04, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x40, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x3e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41,
       0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41, 0x40, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x3e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
       0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x40, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x3e, 0x40});
  wkbRoundTrip(wkt, wkb);
}

TEST(WKBRoundtrip, ExportOptions) {
  s2geography::WKTReader reader;
  auto geog = reader.read_feature("LINESTRING (-64 45, 0 45)");

  WKBWriter writer;
  auto wkbOut = writer.WriteFeature(*geog);

  // smoke test for passing through options: with tessellation -> more
  // coordinates
  s2geography::geoarrow::ExportOptions options;
  options.set_tessellate_tolerance(S1Angle::Radians(0.001));
  WKBWriter writer2(options);
  auto wkbOut2 = writer2.WriteFeature(*geog);

  EXPECT_GT(wkbOut2.size(), wkbOut.size());
}
